#
# (C) Tenable Network Security, Inc.
#


  desc = "
Synopsis :

The remote MagniComp SysInfo agent is not protected. 

Description :

The MagniComp SysInfo agent on the remote host allows the Nessus
server to retrieve information about the system's assets and
configuration, which may help attacker plan more focused attacks
against the affected host. 

Solution :

Edit the AUTH and/or ALLOW keyword settings in the mcsysinfod
configuration file to limit access. 

Risk factor :

Medium / CVSS Base Score : 5.0
(CVSS2#AV:N/AC:L/Au:N/C:P/I:N/A:N)";


if (description)
{
  script_id(26967);
  script_version("$Revision: 1.1 $");

  script_name(english:"MagniComp SysInfo Agent Accessible");
  script_summary(english:"Tries to retrieve system info");

  script_description(english:desc);

  script_category(ACT_GATHER_INFO);
  script_family(english:"Misc.");

  script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc.");

  script_dependencies("find_service1.nasl");
  script_require_ports("Services/mcsysinfod", 11967);

  exit(0);
}


port = get_kb_item("Services/mcsysinfod");
if (!port) port = 11967;
if (!get_port_state(port)) exit(0);


soc = open_sock_tcp(port);
if (!soc) exit(0);


# Read the banner.
banner = "";
while (s = recv_line(socket:soc, length:1024))
{
  s = chomp(s);
  banner += s + '\n';
  if (s =~ "^\* ") break;
}
if (strlen(banner) && "SysInfo Server" >< banner && " talk AUTH" >!< banner)
{
  # nb: possible info classes include "all", "General", "Hardware", "FileSys", 
  #    "Partition", "NetIf", "Network, "VmHost", "Printer", "Patch", "Software",
  #    "License", "Service, "SiteInfo", "device". And the output format
  #    depends on the chosen class.
  class = "General";
  c = "SEND " + class;
  send(socket:soc, data:string(c, "\n"));

  info = "";
  while (s = recv_line(socket:soc, length:1024))
  {
    s = chomp(s);
    if (s =~ "^\* OK") break;
    if (s =~ "^general|")
    {
      f = split(s, sep:"|", keep:FALSE);
      if (strlen(f[3]) && strlen(f[4]))
        info += "  " + f[3] + " : " + crap(data:" ", length:35-strlen(f[3])) + f[4] + '\n';
    }
  }

  if (info)
  {
    report = string(
      desc,
      "\n\n",
      "Plugin output :\n",
      "\n",
      "Nessus was able to collect the following info by querying the MagniComp",
      "SysInfo agent on the remote host :\n",
      "\n",
      info
    );
    security_warning(port:port, data:report);
  }
}
close(soc);
