#
# (C) Tenable Network Security
#

if(description)
{
 script_id(18244);
 script_version("$Revision: 1.11 $");

 script_cve_id("CVE-2005-1476", "CVE-2005-1477", "CVE-2005-1531", "CVE-2005-1532");
 script_bugtraq_id(13544, 13641, 13645);
 script_xref(name:"IAVA", value:"2005-T-0014");

 name["english"] = "Mozilla Browser < 1.7.8";

 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

A web browser installed on the remote host contains multiple
vulnerabilities. 

Description :

The remote version of Mozilla contains various security issues which
may allow an attacker to execute arbitrary code on the remote host. 

See also :

http://www.mozilla.org/security/announce/2005/mfsa2005-43.html
http://www.mozilla.org/security/announce/2005/mfsa2005-44.html

Solution : 

Upgrade to Mozilla 1.7.8 or later.

Risk factor : 

High / CVSS Base Score : 8
(AV:R/AC:H/Au:NR/C:C/A:C/I:C/B:N)";
 script_description(english:desc["english"]);
 
 summary["english"] = "Determines the version of Mozilla";

 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2005-2007 Tenable Network Security");
 family["english"] = "Windows";
 script_family(english:family["english"]);
 
 script_dependencies("mozilla_org_installed.nasl");
 script_require_keys("Mozilla/Version");
 exit(0);
}


include("misc_func.inc");


ver = read_version_in_kb("Mozilla/Version");
if (isnull(ver)) exit(0);

if (
  ver[0] < 1 ||
  (
    ver[0] == 1 &&
    (
      ver[1] < 7 ||
      (ver[1] == 7 && ver[2] < 8)
    )
  )
) security_hole(get_kb_item("SMB/transport"));
