#
# (C) Tenable Network Security
#


if (description) {
  script_id(19719);
  script_version("$Revision: 1.16 $");
  script_cve_id(
    "CVE-2005-2602",
    "CVE-2005-2701",
    "CVE-2005-2702",
    "CVE-2005-2703",
    "CVE-2005-2704",
    "CVE-2005-2705",
    "CVE-2005-2706",
    "CVE-2005-2707",
    "CVE-2005-2871",
    "CVE-2005-3089"
  );
  script_bugtraq_id(14526, 14784, 14916, 14917, 14918, 14919, 14920, 14921, 14923, 14924);

  name["english"] = "Firefox < 1.0.7";
  script_name(english:name["english"]);

  desc["english"] = "
Synopsis :

A web browser on the remote host is prone to multiple flaws, including
arbitrary code execution.

Description :

The remote host is using Firefox, an alternative web browser.

The installed version of Firefox contains various security issues,
several of which are critical as they can be easily exploited to
execute arbitrary shell code on the remote host. 

See also : 

http://www.securityfocus.com/archive/1/407704
http://security-protocols.com/advisory/sp-x17-advisory.txt
http://www.mozilla.org/security/idn.html
http://www.mozilla.org/security/announce/2005/mfsa2005-58.html

Solution : 

Upgrade to Firefox 1.0.7 or later.

Risk factor : 

High / CVSS Base Score : 7 
(AV:R/AC:L/Au:NR/C:P/A:P/I:P/B:N)";
  script_description(english:desc["english"]);
 
  summary["english"] = "Determines the version of Firefox";
  script_summary(english:summary["english"]);
 
  script_category(ACT_GATHER_INFO);
  script_family(english:"Windows");
 
  script_copyright(english:"This script is Copyright (C) 2005-2006 Tenable Network Security");
 
  script_dependencies("mozilla_org_installed.nasl");
  script_require_keys("Mozilla/Firefox/Version");


  exit(0);
}


include("misc_func.inc");


ver = read_version_in_kb("Mozilla/Firefox/Version");
if (isnull(ver)) exit(0);

if (
  ver[0] < 1 ||
  (ver[0] == 1 && ver[1] == 0 && ver[2] < 6)
) security_hole(get_kb_item("SMB/transport"));
