#
# (C) Tenable Network Security, Inc.
#


if (description)
{
  script_id(29744);
  script_version("$Revision: 1.1 $");

  if (NASL_LEVEL >= 3000)
  {
    script_cve_id(
      "CVE-2005-4134",
      "CVE-2006-0292",
      "CVE-2006-0296",
      "CVE-2006-0748",
      "CVE-2006-0749",
      "CVE-2006-1727",
      "CVE-2006-1728",
      "CVE-2006-1729",
      "CVE-2006-1730",
      "CVE-2006-1731",
      "CVE-2006-1732",
      "CVE-2006-1733",
      "CVE-2006-1734",
      "CVE-2006-1735",
      "CVE-2006-1736",
      "CVE-2006-1737",
      "CVE-2006-1738",
      "CVE-2006-1739",
      "CVE-2006-1740",
      "CVE-2006-1741",
      "CVE-2006-1742",
      "CVE-2006-1790"
    );
  }
  script_bugtraq_id(15773, 16476, 17516);

  script_name(english:"Firefox < 1.0.8");
  script_summary(english:"Checks Firefox version number");

  desc = "
Synopsis :

A web browser on the remote host is prone to multiple flaws. 

Description :

The installed version of Firefox contains various security issues,
some of which may lead to execution of arbitrary code on the affected
host subject to the user's privileges. 

See also : 

http://www.mozilla.org/security/announce/2006/mfsa2006-01.html
http://www.mozilla.org/security/announce/2006/mfsa2006-03.html
http://www.mozilla.org/security/announce/2006/mfsa2006-05.html
http://www.mozilla.org/security/announce/2006/mfsa2006-09.html
http://www.mozilla.org/security/announce/2006/mfsa2006-10.html
http://www.mozilla.org/security/announce/2006/mfsa2006-11.html
http://www.mozilla.org/security/announce/2006/mfsa2006-12.html
http://www.mozilla.org/security/announce/2006/mfsa2006-13.html
http://www.mozilla.org/security/announce/2006/mfsa2006-14.html
http://www.mozilla.org/security/announce/2006/mfsa2006-15.html
http://www.mozilla.org/security/announce/2006/mfsa2006-16.html
http://www.mozilla.org/security/announce/2006/mfsa2006-17.html
http://www.mozilla.org/security/announce/2006/mfsa2006-18.html
http://www.mozilla.org/security/announce/2006/mfsa2006-19.html
http://www.mozilla.org/security/announce/2006/mfsa2006-22.html
http://www.mozilla.org/security/announce/2006/mfsa2006-23.html
http://www.mozilla.org/security/announce/2006/mfsa2006-24.html
http://www.mozilla.org/security/announce/2006/mfsa2006-25.html
http://www.mozilla.org/security/announce/2006/mfsa2006-27.html

Solution : 

Upgrade to Firefox 1.0.8 or later. 

Risk factor : 

High / CVSS Base Score : 7.5
(CVSS2#AV:N/AC:L/Au:N/C:P/I:P/A:P)";
  script_description(english:desc);
 
  script_category(ACT_GATHER_INFO);
  script_family(english:"Windows");
 
  script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc.");
 
  script_dependencies("mozilla_org_installed.nasl");
  script_require_keys("Mozilla/Firefox/Version");

  exit(0);
}


include("misc_func.inc");


ver = read_version_in_kb("Mozilla/Firefox/Version");
if (isnull(ver)) exit(0);

if (
  ver[0] < 1 ||
  (ver[0] == 1 && ver[1] == 0 && ver[2] < 8)
) security_hole(get_kb_item("SMB/transport"));
