#
# (C) Tenable Network Security, Inc.
#


if (description)
{
  script_id(24875);
  script_version("$Revision: 1.3 $");

  script_cve_id("CVE-2007-1562");
  script_bugtraq_id(23082);

  script_name(english:"Firefox < 1.5.0.11 / 2.0.0.3");
  script_summary(english:"Checks version of Firefox");

  desc = "
Synopsis :

The remote Windows host contains a web browser that can be manipulated
remotely for network abuse. 

Description :

The FTP client support in the installed version of Firefox has a flaw
that could allow a remote attacker with control of an FTP server to
perform a rudimentary port scan of, for example, the user's internal
network. 

See also :

http://bindshell.net/papers/ftppasv
http://www.mozilla.org/security/announce/2007/mfsa2007-11.html

Solution :

Upgrade to Firefox 1.5.0.11 / 2.0.0.3 or later. 

Risk factor :

Medium / CVSS Base Score : 6.8
(CVSS2#AV:N/AC:M/Au:N/C:P/I:P/A:P)";
  script_description(english:desc);
 
  script_category(ACT_GATHER_INFO);
  script_family(english:"Windows");
 
  script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc.");
 
  script_dependencies("mozilla_org_installed.nasl");
  script_require_keys("Mozilla/Firefox/Version");

  exit(0);
}


include("misc_func.inc");


ver = read_version_in_kb("Mozilla/Firefox/Version");
if (isnull(ver)) exit(0);

if (
  ver[0] < 1 ||
  (
    ver[0] == 1 &&
    (
      ver[1] < 5 ||
      (ver[1] == 5 && ver[2] == 0 && ver[3] < 11)
    ) 
  ) ||
  (ver[0] == 2 && ver[1] == 0 && ver[2] == 0 && ver[3] < 3)
) security_warning(get_kb_item("SMB/transport"));
