#
# (C) Tenable Network Security, Inc.
#


if (description)
{
  script_id(25349);
  script_version("$Revision: 1.6 $");

  script_cve_id(
    "CVE-2007-1362",
    "CVE-2007-2867",
    "CVE-2007-2868",
    "CVE-2007-2869",
    "CVE-2007-2870",
    "CVE-2007-2871"
  );
  script_bugtraq_id(22879, 24242);
  script_xref(name:"OSVDB", value:"35139");

  script_name(english:"Firefox < 1.5.0.12 / 2.0.0.4");
  script_summary(english:"Checks version of Firefox");

  desc = "
Synopsis :

The remote Windows host contains a web browser that is affected by
multiple vulnerabilities. 

Description :

The installed version of Firefox is affected by various security
issues, one of which may lead to execution of arbitrary code on the affected
host subject to the user's privileges. 

See also :

http://www.mozilla.org/security/announce/2007/mfsa2007-12.html
http://www.mozilla.org/security/announce/2007/mfsa2007-13.html
http://www.mozilla.org/security/announce/2007/mfsa2007-14.html
http://www.mozilla.org/security/announce/2007/mfsa2007-16.html
http://www.mozilla.org/security/announce/2007/mfsa2007-17.html

Solution :

Upgrade to Firefox 1.5.0.12 / 2.0.0.4 or later. 

Risk factor :

High / CVSS Base Score : 9.3
(CVSS2#AV:N/AC:M/Au:N/C:C/I:C/A:C)";
  script_description(english:desc);
 
  script_category(ACT_GATHER_INFO);
  script_family(english:"Windows");
 
  script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc.");
 
  script_dependencies("mozilla_org_installed.nasl");
  script_require_keys("Mozilla/Firefox/Version");

  exit(0);
}


include("misc_func.inc");


ver = read_version_in_kb("Mozilla/Firefox/Version");
if (isnull(ver)) exit(0);

if (
  ver[0] < 1 ||
  (
    ver[0] == 1 &&
    (
      ver[1] < 5 ||
      (ver[1] == 5 && ver[2] == 0 && ver[3] < 12)
    ) 
  ) ||
  (ver[0] == 2 && ver[1] == 0 && ver[2] == 0 && ver[3] < 4)
) security_hole(get_kb_item("SMB/transport"));
