#
# (C) Tenable Network Security
#


if (description)
{
  script_id(21322);
  script_version("$Revision: 1.8 $");

  script_cve_id("CVE-2006-1993");
  script_bugtraq_id(17671);

  script_name(english:"Firefox < 1.5.0.3");
  script_summary(english:"Checks Firefox version number");

  desc = "
Synopsis :

A web browser on the remote host may be prone to a denial of service
attack. 

Description :

The installed version of Firefox may allow a malicious site to crash
the browser and potentially to run malicious code when attempting to
use a deleted controller context. 

Successful exploitation requires that 'designMode' be turned on. 

See also : 

http://www.securityfocus.com/archive/1/archive/1/431878/100/0/threaded
http://www.mozilla.org/security/announce/2006/mfsa2006-30.html

Solution : 

Upgrade to Firefox 1.5.0.3 or later. 

Risk factor : 

Medium / CVSS Base Score : 5.1
(CVSS2#AV:N/AC:H/Au:N/C:P/I:P/A:P)";
  script_description(english:desc);
 
  script_category(ACT_GATHER_INFO);
  script_family(english:"Windows");
 
  script_copyright(english:"This script is Copyright (C) 2006 Tenable Network Security");
 
  script_dependencies("mozilla_org_installed.nasl");
  script_require_keys("Mozilla/Firefox/Version");
  exit(0);
}


include("misc_func.inc");


ver = read_version_in_kb("Mozilla/Firefox/Version");
if (isnull(ver)) exit(0);

if (ver[0] == 1 && ver[1] == 5 && ver[2] == 0 && ver[3] < 3) 
  security_warning(get_kb_item("SMB/transport"));
