#
# (C) Tenable Network Security
#


if (description)
{
  script_id(23930);
  script_version("$Revision: 1.3 $");

  script_cve_id(
    "CVE-2006-6497",
    "CVE-2006-6498",
    "CVE-2006-6499",
    "CVE-2006-6500",
    "CVE-2006-6501",
    "CVE-2006-6502",
    "CVE-2006-6503",
    "CVE-2006-6504",
    "CVE-2006-6506",
    "CVE-2006-6507"
  );
  script_bugtraq_id(21668);

  script_name(english:"Firefox < 1.5.0.9 / 2.0.0.1");
  script_summary(english:"Checks version of Firefox");

  desc = "
Synopsis :

The remote Windows host contains a web browser that is affected by
multiple vulnerabilities. 

Description :

The installed version of Firefox is affected by various security
issues, some of which may lead to execution of arbitrary code on the
affected host subject to the user's privileges. 

See also : 

http://www.mozilla.org/security/announce/2006/mfsa2006-68.html
http://www.mozilla.org/security/announce/2006/mfsa2006-69.html
http://www.mozilla.org/security/announce/2006/mfsa2006-70.html
http://www.mozilla.org/security/announce/2006/mfsa2006-71.html
http://www.mozilla.org/security/announce/2006/mfsa2006-72.html
http://www.mozilla.org/security/announce/2006/mfsa2006-73.html
http://www.mozilla.org/security/announce/2006/mfsa2006-75.html
http://www.mozilla.org/security/announce/2006/mfsa2006-76.html

Solution : 

Upgrade to Firefox 1.5.0.9 / 2.0.0.1 or later. 

Risk factor : 

High / CVSS Base Score : 9.3
(CVSS2#AV:N/AC:M/Au:N/C:C/I:C/A:C)";
  script_description(english:desc);
 
  script_category(ACT_GATHER_INFO);
  script_family(english:"Windows");
 
  script_copyright(english:"This script is Copyright (C) 2006-2007 Tenable Network Security");
 
  script_dependencies("mozilla_org_installed.nasl");
  script_require_keys("Mozilla/Firefox/Version");

  exit(0);
}


include("misc_func.inc");


ver = read_version_in_kb("Mozilla/Firefox/Version");
if (isnull(ver)) exit(0);

if (
  ver[0] < 1 ||
  (
    ver[0] == 1 &&
    (
      ver[1] < 5 ||
      (ver[1] == 5 && ver[2] == 0 && ver[3] < 9)
    ) 
  ) ||
  (ver[0] == 2 && ver[1] == 0 && ver[2] == 0 && ver[3] < 1)
) security_hole(get_kb_item("SMB/transport"));
