#
# (C) Tenable Network Security, Inc.
#


if (description)
{
  script_id(26068);
  script_version("$Revision: 1.1 $");

  script_name(english:"Firefox < 2.0.0.7");
  script_summary(english:"Checks version of Firefox");

  desc = "
Synopsis :

The remote Windows host contains a web browser that may allow
arbitrary code execution. 

Description :

The installed version of Firefox may allow a remote attacker to run
script commands subject to the user's privileges via 'qtnext'
attributes in QuickTime Media-Link files. 

Note that this issue can be exploited even if support for Javascript
in the browser has been disabled. 

See also :

http://www.mozilla.org/security/announce/2007/mfsa2007-28.html

Solution :

Upgrade to Firefox 2.0.0.7 or later. 

Risk factor :

High / CVSS Base Score : 9.3
(CVSS2#AV:N/AC:M/Au:N/C:C/I:C/A:C)";
  script_description(english:desc);
 
  script_category(ACT_GATHER_INFO);
  script_family(english:"Windows");
 
  script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc.");
 
  script_dependencies("mozilla_org_installed.nasl");
  script_require_keys("Mozilla/Firefox/Version");

  exit(0);
}


include("misc_func.inc");


ver = read_version_in_kb("Mozilla/Firefox/Version");
if (isnull(ver)) exit(0);

if (
  ver[0] < 2 ||
  (ver[0] == 2 && ver[1] == 0 && ver[2] == 0 && ver[3] < 7)
) security_hole(get_kb_item("SMB/transport"));
