#
# (C) Tenable Network Security
#

if(description)
{
 script_id(12642);
 script_version("$Revision: 1.15 $");

 script_cve_id("CVE-2004-0648");
 script_bugtraq_id(10681);
 script_xref(name:"OSVDB", value:"7595");

 name["english"] = "Mozilla/Firefox code execution";

 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is using Mozilla and/or Firefox, an alternative web browser.

The remote version of this software contains a weakness which may allow an
attacker to execute arbitrary programs on the remote host.

Solution : See http://mozilla.org/security/shell.html
Risk factor : High";



 script_description(english:desc["english"]);
 
 summary["english"] = "Determines the version of Mozilla/Firefox";

 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004-2006 Tenable Network Security");
 family["english"] = "Windows";
 script_family(english:family["english"]);
 
 script_dependencies("mozilla_org_installed.nasl");
 if ( NASL_LEVEL >= 3206 ) script_require_ports("Mozilla/Version", "Mozilla/Firefox/Version");
 exit(0);
}


include("misc_func.inc");


ver = read_version_in_kb("Mozilla/Version");
if (!isnull(ver))
{
  if (
    ver[0] < 1 ||
    (
      ver[0] == 1 &&
      (
        ver[1] < 7 ||
        (ver[1] == 7 && ver[2] == 0 && ver[3] < 1)
      )
    )
  )  security_hole(get_kb_item("SMB/transport"));
}

ver = read_version_in_kb("Mozilla/Firefox/Version");
if (!isnull(ver))
{
  if (
    ver[0] == 0 &&
    (
      ver[1] < 9 ||
      (ver[1] == 9 && ver[2] < 2)
    )
  ) security_hole(get_kb_item("SMB/transport"));
}
