#
# (C) Tenable Network Security
#

if(description)
{
 script_id(15712);
 script_version("$Revision: 1.7 $");

 script_cve_id(
  "CVE-2005-0141",
  "CVE-2005-0143",
  "CVE-2005-0144",
  "CVE-2005-0145",
  "CVE-2005-0146",
  "CVE-2005-0147",
  "CVE-2005-0150"
 );
 script_bugtraq_id(11648,12407);

 name["english"] = "Firefox IMG Tag Multiple Vulnerabilities";
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is using Firefox, an alternative web browser.

The remote version of this software contains a security issue which
may allow an attacker to determine existence of local files, cause a
DoS and steal passwords (Windows only). 

The security vulnerability is due to the fact that Firefox does not
handle correctly <IMG> tag.

Solution : Upgrade to Firefox 1.0.0 or later.
Risk factor : High";
 script_description(english:desc["english"]);
 
 summary["english"] = "Determines the version of Firefox";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004-2006 Tenable Network Security");
 family["english"] = "Windows";
 script_family(english:family["english"]);
 
 script_dependencies("mozilla_org_installed.nasl");
 script_require_keys("Mozilla/Firefox/Version");

 exit(0);
}


include("misc_func.inc");


ver = read_version_in_kb("Mozilla/Firefox/Version");
if (isnull(ver)) exit(0);

if (ver[0] < 1) security_hole(get_kb_item("SMB/transport"));
