#
# (C) Tenable Network Security
#

if(description)
{
 script_id(14728);
 script_cve_id("CVE-2004-0904", "CVE-2004-0905", "CVE-2004-0906", "CVE-2004-0908");
 script_bugtraq_id(11194, 11192, 11179, 11177, 11171, 11169 );
 script_version("$Revision: 1.10 $");

 name["english"] = "Mozilla/Firefox multiple flaws";

 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is using Mozilla and/or Firefox, an alternative web browser.

The remote version of this software is vulnerable to several flaws which
may allow an attacker to execute arbitrary code on the remote host, to
get access to content of the users clipboard or to perform a cross-domain
cross site scripting attack.

To exploit this flaw, an attacker would need to set up a rogue website 
and lure a victim on the remote host into visiting it.

Solution : Upgrade to Mozilla 1.7.3 or Firefox 0.10.0
Risk factor : High";



 script_description(english:desc["english"]);
 
 summary["english"] = "Determines the version of Mozilla";

 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004-2007 Tenable Network Security");
 family["english"] = "Windows";
 script_family(english:family["english"]);
 
 script_dependencies("mozilla_org_installed.nasl");
 if ( NASL_LEVEL >= 3206 ) script_require_ports("Mozilla/Version", "Mozilla/Firefox/Version");
 exit(0);
}


include("misc_func.inc");


ver = read_version_in_kb("Mozilla/Version");
if (!isnull(ver))
{
  if (
    ver[0] < 1 ||
    (
      ver[0] == 1 &&
      (
        ver[1] < 7 ||
        (ver[1] == 7 && ver[2] < 3)
      )
    )
  )  security_hole(get_kb_item("SMB/transport"));
}

ver = read_version_in_kb("Mozilla/Firefox/Version");
if (!isnull(ver))
{
  if (ver[0] == 0 && ver[1] < 10)
    security_hole(get_kb_item("SMB/transport"));
}
