#
#  (C) Tenable Network Security
#


 desc = "
Synopsis :

The remote Windows host contains one or more applications from
Mozilla.org. 

Description :

There is at least one open-source application from Mozilla.org
installed on the remote Windows host. 

See also :

http://www.mozilla.org/products/

Risk factor : 

None";


if (description) {
  script_id(20862);
  script_version("$Revision: 1.15 $");

  script_name(english:"Mozilla.org Application Detection");
  script_summary(english:"Checks for various applications from Mozilla.org"); 
 
  script_description(english:desc);
 
  script_category(ACT_GATHER_INFO);
  script_family(english:"Windows");

  script_copyright(english:"This script is Copyright (C) 2006 Tenable Network Security");

  script_dependencies("smb_hotfixes.nasl");
  script_require_keys("SMB/Registry/Enumerated");
  script_require_ports(139, 445);

  exit(0);
}


include("global_settings.inc");
include("misc_func.inc");
include("smb_func.inc");


function display_dword (dword, nox)
{
 local_var tmp;

 if (isnull(nox) || (nox == FALSE))
   tmp = "0x";
 else
   tmp = "";

 return string (tmp,
               toupper(
                  hexstr(
                    raw_string(
                               (dword >>> 24) & 0xFF,
                               (dword >>> 16) & 0xFF,
                               (dword >>> 8) & 0xFF,
                               dword & 0xFF
                              )
                        )
                      )
               );
}


# Connect to the appropriate share.
if (!get_kb_item("SMB/Registry/Enumerated")) exit(0);
name    =  kb_smb_name();
port    =  kb_smb_transport();
if (!get_port_state(port)) exit(0);
login   =  kb_smb_login();
pass    =  kb_smb_password();
domain  =  kb_smb_domain();

soc = open_sock_tcp(port);
if (!soc) exit(0);

session_init(socket:soc, hostname:name);
rc = NetUseAdd(login:login, password:pass, domain:domain, share:"IPC$");
if (rc != 1) {
  NetUseDel();
  exit(0);
}


# Connect to remote registry.
hklm = RegConnectRegistry(hkey:HKEY_LOCAL_MACHINE);
if (isnull(hklm)) {
  if (log_verbosity > 1) debug_print("can't connect to the remote registry!", level:0);
  NetUseDel();
  exit(0);
}


# Determine if various applications are installed.
exes = make_array();
# - Mozilla Browser.
key = "SOFTWARE\mozilla.org\Mozilla";
key_h = RegOpenKey(handle:hklm, key:key, mode:MAXIMUM_ALLOWED);
if (!isnull(key_h)) {
  item = RegQueryValue(handle:key_h, item:"CurrentVersion");
  if (!isnull(item)) {
    ver = item[1];

    key2 = "SOFTWARE\mozilla.org\Mozilla\" + ver + "\Main";
    key_h2 = RegOpenKey(handle:hklm, key:key2, mode:MAXIMUM_ALLOWED);
    if (!isnull(key_h2)) {
      item = RegQueryValue(handle:key_h2, item:"PathToExe");
      if (!isnull(item)) exes[item[1]] = "Mozilla Browser";
      RegCloseKey(handle:key_h2);
    }
  }
  RegCloseKey(handle:key_h);
}
# - Mozilla Firefox.
key = "SOFTWARE\Mozilla\Mozilla Firefox";
key_h = RegOpenKey(handle:hklm, key:key, mode:MAXIMUM_ALLOWED);
if (!isnull(key_h)) {
  item = RegQueryValue(handle:key_h, item:"CurrentVersion");
  if (!isnull(item)) {
    ver = item[1];

    key2 = "SOFTWARE\Mozilla\Mozilla Firefox\" + ver + "\Main";
    key_h2 = RegOpenKey(handle:hklm, key:key2, mode:MAXIMUM_ALLOWED);
    if (!isnull(key_h2)) {
      item = RegQueryValue(handle:key_h2, item:"PathToExe");
      if (!isnull(item)) exes[item[1]] = "Mozilla Firefox";
      RegCloseKey(handle:key_h2);
    }
  }
  RegCloseKey(handle:key_h);
}
# nb: this is for older versions of Firefox (eg, 0.8).
else {
  key = "SOFTWARE\mozilla.org\Mozilla Firefox";
  key_h = RegOpenKey(handle:hklm, key:key, mode:MAXIMUM_ALLOWED);
  if (!isnull(key_h)) {
    item = RegQueryValue(handle:key_h, item:"CurrentVersion");
    if (!isnull(item)) {
      ver = item[1];

      key2 = "SOFTWARE\mozilla.org\Mozilla Firefox\" + ver + "\Main";
      key_h2 = RegOpenKey(handle:hklm, key:key2, mode:MAXIMUM_ALLOWED);
      if (!isnull(key_h2)) {
        item = RegQueryValue(handle:key_h2, item:"PathToExe");
        if (!isnull(item)) exes[item[1]] = "Mozilla Firefox";
        RegCloseKey(handle:key_h2);
      }
    }
    RegCloseKey(handle:key_h);
  }
}
# - Mozilla Thunderbird.
key = "SOFTWARE\Mozilla\Mozilla Thunderbird";
key_h = RegOpenKey(handle:hklm, key:key, mode:MAXIMUM_ALLOWED);
if (!isnull(key_h)) {
  item = RegQueryValue(handle:key_h, item:"CurrentVersion");
  if (!isnull(item)) {
    ver = item[1];

    key2 = "SOFTWARE\Mozilla\Mozilla Thunderbird\" + ver + "\Main";
    key_h2 = RegOpenKey(handle:hklm, key:key2, mode:MAXIMUM_ALLOWED);
    if (!isnull(key_h2)) {
      item = RegQueryValue(handle:key_h2, item:"PathToExe");
      if (!isnull(item)) exes[item[1]] = "Mozilla Thunderbird";
      RegCloseKey(handle:key_h2);
    }
  }
  RegCloseKey(handle:key_h);
}
# - SeaMonkey.
key = "SOFTWARE\mozilla.org\SeaMonkey";
key_h = RegOpenKey(handle:hklm, key:key, mode:MAXIMUM_ALLOWED);
if (!isnull(key_h)) {
  item = RegQueryValue(handle:key_h, item:"CurrentVersion");
  if (!isnull(item)) {
    ver = item[1];

    key2 = "SOFTWARE\mozilla.org\SeaMonkey\" + ver + "\Main";
    key_h2 = RegOpenKey(handle:hklm, key:key2, mode:MAXIMUM_ALLOWED);
    if (!isnull(key_h2)) {
      item = RegQueryValue(handle:key_h2, item:"PathToExe");
      if (!isnull(item)) exes[item[1]] = "SeaMonkey";
      RegCloseKey(handle:key_h2);
    }
  }
  RegCloseKey(handle:key_h);
}
RegCloseKey(handle:hklm);


# Determine the version of each app from each executable itself.
info = "";
foreach exe (keys(exes))
{
  # Determine its version from the executable itself.
  share = ereg_replace(pattern:"^([A-Za-z]):.*", replace:"\1$", string:exe);
  exe2 =  ereg_replace(pattern:"^[A-Za-z]:(.*)", replace:"\1", string:exe);
  NetUseDel(close:FALSE);

  rc = NetUseAdd(login:login, password:pass, domain:domain, share:share);
  if (rc != 1)
  {
    NetUseDel();
    exit(1);
  }

  fh = CreateFile(
    file:exe2,
    desired_access:GENERIC_READ,
    file_attributes:FILE_ATTRIBUTE_NORMAL,
    share_mode:FILE_SHARE_READ,
    create_disposition:OPEN_EXISTING
  );

  ver = NULL;
  if (!isnull(fh))
  {
    filever = GetFileVersion(handle:fh);
    ret = GetFileVersionEx(handle:fh);
    CloseFile(handle:fh);

    if (!isnull(ret)) children = ret['Children'];
    if (!isnull(children))
    {
      varfileinfo = children['VarFileInfo'];
      if (!isnull(varfileinfo))
      {
        translation =
          (get_word (blob:varfileinfo['Translation'], pos:0) << 16) +
          get_word (blob:varfileinfo['Translation'], pos:2);
        translation = tolower(display_dword(dword:translation, nox:TRUE));
      }
      stringfileinfo = children['StringFileInfo'];
      if (!isnull(stringfileinfo) && !isnull(translation))
      {
        data = stringfileinfo[translation];
        if (!isnull(data)) ver = data['ProductVersion'];
      }
    }

    prod = exes[exe];
    if (prod == "Mozilla Firefox")
    {
      if (!isnull(filever) && ver && ver =~ "^1\.7\.3\: 2004")
        ver = string(filever[0], ".", filever[1], ".", filever[2], ".", filever[3]);
    }

    if (!isnull(ver) && !isnull(prod))
    {
      if (prod == "Mozilla Browser") kb_name = "Mozilla/Version";
      else kb_name = str_replace(find:" ", replace:"/", string:string(prod, "/Version"));

      save_version_in_kb(key:kb_name, ver:ver);
      info += strcat(" - ", prod, " version ", ver, ' is installed as\n   ', exe, '\n\n');
    }
  }
}


if (info) {
  report = strcat(
    desc,
    '\n\n',
    'Plugin output :\n',
    '\n',
    info
  );
  security_note(port:kb_smb_transport(), data:report);
}


# Clean up.
NetUseDel();
