#
# (C) Tenable Network Security
#


if (description)
{
  script_id(24748);
  script_version("$Revision: 1.10 $");

  script_cve_id("CVE-2007-0009", "CVE-2007-0775", "CVE-2007-0776", "CVE-2007-0777", "CVE-2007-1282");
  script_bugtraq_id(22566, 22694, 22845);
  script_xref(name:"OSVDB", value:"32105");
  script_xref(name:"OSVDB", value:"32106");
  script_xref(name:"OSVDB", value:"32113");
  script_xref(name:"OSVDB", value:"32114");
  script_xref(name:"OSVDB", value:"32115");

  script_name(english:"Mozilla Thunderbird < 1.5.0.10");
  script_summary(english:"Checks version of Mozilla Thunderbird");
 
  desc = "
Synopsis :

The remote Windows host contains a mail client that is affected by
multiple vulnerabilities. 

Description :

The remote version of Mozilla Thunderbird suffers from various
security issues, at least one that may lead to execution of arbitrary
code on the affected host subject to the user's privileges. 

See also : 

http://www.mozilla.org/security/announce/2007/mfsa2007-01.html
http://www.mozilla.org/security/announce/2007/mfsa2007-06.html
http://www.mozilla.org/security/announce/2007/mfsa2007-10.html

Solution :

Upgrade to Mozilla Thunderbird 1.5.0.10 or later. 

Risk factor : 

High / CVSS Base Score : 9.3
(CVSS2#AV:N/AC:M/Au:N/C:C/I:C/A:C)";
  script_description(english:desc);
 
  script_category(ACT_GATHER_INFO);
  script_family(english:"Windows");
 
  script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 
  script_dependencies("mozilla_org_installed.nasl");
  script_require_keys("Mozilla/Thunderbird/Version");

  exit(0);
}


include("misc_func.inc");


ver = read_version_in_kb("Mozilla/Thunderbird/Version");
if (isnull(ver)) exit(0);

if (
  ver[0] < 1 ||
  (
    ver[0] == 1 &&
    (
      ver[1] < 5 ||
      (ver[1] == 5 && ver[2] == 0 && ver[3] < 10)
    )
  )
) security_hole(get_kb_item("SMB/transport"));
