#
# (C) Tenable Network Security, Inc.
#


if (description)
{
  script_id(25350);
  script_version("$Revision: 1.5 $");

  script_cve_id("CVE-2007-1558", "CVE-2007-2867", "CVE-2007-2868");
  script_bugtraq_id(23257, 24242);

  script_name(english:"Mozilla Thunderbird < 1.5.0.12");
  script_summary(english:"Checks version of Mozilla Thunderbird");
 
  desc = "
Synopsis :

The remote Windows host contains a mail client that is affected by
multiple vulnerabilities. 

Description :

The remote version of Mozilla Thunderbird suffers from various
security issues, at least one that may lead to execution of arbitrary
code on the affected host subject to the user's privileges. 

See also : 

http://www.mozilla.org/security/announce/2007/mfsa2007-12.html
http://www.mozilla.org/security/announce/2007/mfsa2007-15.html

Solution :

Upgrade to Mozilla Thunderbird 1.5.0.12 or later. 

Risk factor : 

High / CVSS Base Score : 9.3
(CVSS2#AV:N/AC:M/Au:N/C:C/I:C/A:C)";
  script_description(english:desc);
 
  script_category(ACT_GATHER_INFO);
  script_family(english:"Windows");
 
  script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc.");
 
  script_dependencies("mozilla_org_installed.nasl");
  script_require_keys("Mozilla/Thunderbird/Version");

  exit(0);
}


include("misc_func.inc");


ver = read_version_in_kb("Mozilla/Thunderbird/Version");
if (isnull(ver)) exit(0);

if (
  ver[0] < 1 ||
  (
    ver[0] == 1 &&
    (
      ver[1] < 5 ||
      (ver[1] == 5 && ver[2] == 0 && ver[3] < 12)
    )
  )
) security_hole(get_kb_item("SMB/transport"));
