#
# (C) Tenable Network Security, Inc.
#


if (description)
{
  script_id(29743);
  script_version("$Revision: 1.1 $");

  script_cve_id("CVE-2007-5339", "CVE-2007-5340");
  script_bugtraq_id(26132);

  script_name(english:"Mozilla Thunderbird < 1.5.0.14");
  script_summary(english:"Checks version of Mozilla Thunderbird");
 
  desc = "
Synopsis :

The remote Windows host contains a mail client that is affected by
multiple vulnerabilities. 

Description :

The remote version of Mozilla Thunderbird suffers from various
security issues, several of which may lead to execution of arbitrary
code on the affected host subject to the user's privileges. 

See also : 

http://www.mozilla.org/security/announce/2007/mfsa2007-29.html
http://www.mozilla.org/security/announce/2007/mfsa2007-40.html

Solution :

Upgrade to Mozilla Thunderbird 1.5.0.14 or later. 

Risk factor : 

High / CVSS Base Score : 9.3
(CVSS2#AV:N/AC:M/Au:N/C:C/I:C/A:C)";
  script_description(english:desc);
 
  script_category(ACT_GATHER_INFO);
  script_family(english:"Windows");
 
  script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc.");
 
  script_dependencies("mozilla_org_installed.nasl");
  script_require_keys("Mozilla/Thunderbird/Version");

  exit(0);
}


include("misc_func.inc");


ver = read_version_in_kb("Mozilla/Thunderbird/Version");
if (isnull(ver)) exit(0);

if (
  ver[0] < 1 ||
  (
    ver[0] == 1 &&
    (
      ver[1] < 5 ||
      (ver[1] == 5 && ver[2] == 0 && ver[3] < 14)
    )
  )
) security_hole(get_kb_item("SMB/transport"));
