#
# (C) Tenable Network Security
#


if (description)
{
  script_id(23929);
  script_version("$Revision: 1.4 $");

  script_cve_id(
    "CVE-2006-6497",
    "CVE-2006-6498",
    "CVE-2006-6499",
    "CVE-2006-6500",
    "CVE-2006-6501",
    "CVE-2006-6502",
    "CVE-2006-6503",
    "CVE-2006-6504",
    "CVE-2006-6505"
  );
  script_bugtraq_id(21668);

  script_name(english:"Mozilla Thunderbird < 1.5.0.9");
  script_summary(english:"Checks version of Mozilla Thunderbird");
 
  desc = "
Synopsis :

The remote Windows host contains a mail client that is affected by
multiple vulnerabilities. 

Description :

The remote version of Mozilla Thunderbird suffers from various
security issues, at least one that may lead to execution of arbitrary
code on the affected host subject to the user's privileges. 

See also : 

http://www.mozilla.org/security/announce/2006/mfsa2006-68.html
http://www.mozilla.org/security/announce/2006/mfsa2006-69.html
http://www.mozilla.org/security/announce/2006/mfsa2006-70.html
http://www.mozilla.org/security/announce/2006/mfsa2006-71.html
http://www.mozilla.org/security/announce/2006/mfsa2006-72.html
http://www.mozilla.org/security/announce/2006/mfsa2006-73.html
http://www.mozilla.org/security/announce/2006/mfsa2006-74.html

Solution :

Upgrade to Mozilla Thunderbird 1.5.0.9 or later. 

Risk factor : 

High / CVSS Base Score : 9.3
(CVSS2#AV:N/AC:M/Au:N/C:C/I:C/A:C)";
  script_description(english:desc);
 
  script_category(ACT_GATHER_INFO);
  script_family(english:"Windows");
 
  script_copyright(english:"This script is Copyright (C) 2006-2007 Tenable Network Security");
 
  script_dependencies("mozilla_org_installed.nasl");
  script_require_keys("Mozilla/Thunderbird/Version");

  exit(0);
}


include("misc_func.inc");


ver = read_version_in_kb("Mozilla/Thunderbird/Version");
if (isnull(ver)) exit(0);

if (
  ver[0] < 1 ||
  (
    ver[0] == 1 &&
    (
      ver[1] < 5 ||
      (ver[1] == 5 && ver[2] == 0 && ver[3] < 9)
    )
  )
) security_hole(get_kb_item("SMB/transport"));
