#
# (C) Tenable Network Security, Inc.
#


if (description)
{
  script_id(25837);
  script_version("$Revision: 1.7 $");

  script_cve_id("CVE-2007-3844", "CVE-2007-3845", "CVE-2007-4041");
  script_bugtraq_id(25053, 25142);
  script_xref(name:"OSVDB", value:"38026");
  script_xref(name:"OSVDB", value:"38031");

  script_name(english:"Mozilla Thunderbird < 1.5.0.13 / 2.0.0.6");
  script_summary(english:"Checks version of Mozilla Thunderbird");
 
  desc = "
Synopsis :

The remote Windows host contains a mail client that is affected by
multiple vulnerabilities. 

Description :

The installed version of Mozilla Thunderbird allows unescaped URIs to
be passed to external programs, which may lead to execution of
arbitrary code on the affected host subject to the user's privileges,
and could also allow privilege escalation attacks against addons that
create 'about:blank' windows and populate them in certain ways. 

See also :

http://www.mozilla.org/security/announce/2007/mfsa2007-26.html
http://www.mozilla.org/security/announce/2007/mfsa2007-27.html

Solution :

Upgrade to Mozilla Thunderbird 1.5.0.13 / 2.0.0.6 or later. 

Risk factor : 

High / CVSS Base Score : 9.3
(CVSS2#AV:N/AC:M/Au:N/C:C/I:C/A:C)";
  script_description(english:desc);
 
  script_category(ACT_GATHER_INFO);
  script_family(english:"Windows");
 
  script_copyright(english:"This script is Copyright (C) 2007-2008 Tenable Network Security, Inc.");
 
  script_dependencies("mozilla_org_installed.nasl");
  script_require_keys("Mozilla/Thunderbird/Version");

  exit(0);
}


include("misc_func.inc");


ver = read_version_in_kb("Mozilla/Thunderbird/Version");
if (isnull(ver)) exit(0);

if (
  ver[0] < 1 ||
  (
    ver[0] == 1 && 
    (
      ver[1] < 5 ||
      (ver[1] == 5 && ver[2] == 0 && ver[3] < 13)
    )
  ) ||
  (ver[0] == 2 && ver[1] == 0 && ver[2] == 0 && ver[3] < 6)
) security_hole(get_kb_item("SMB/transport"));
