#
# (C) Tenable Network Security, Inc.
#


if (description)
{
  script_id(28226);
  script_version("$Revision: 1.1 $");

  script_cve_id("CVE-2007-4841", "CVE-2007-5339", "CVE-2007-5340");
  script_bugtraq_id(26132);

  script_name(english:"Mozilla Thunderbird < 2.0.0.9");
  script_summary(english:"Checks version of Mozilla Thunderbird");
 
  desc = "
Synopsis :

The remote Windows host contains a mail client that is affected by
multiple vulnerabilities. 

Description :

The remote version of Mozilla Thunderbird is affected by some memory
corruption issues that may result in denial of service or remote code
execution if Javascript is enabled when viewing specially-crafted
messages. 

In addition, it fails to properly handle URIs with invalid %-encoding,
which might allow for launching a program other than the register
protocol-handler. 

See also :

http://www.mozilla.org/security/announce/2007/mfsa2007-29.html
http://www.mozilla.org/security/announce/2007/mfsa2007-36.html

Solution :

Upgrade to Mozilla Thunderbird 2.0.0.9 or later. 

Risk factor : 

High / CVSS Base Score : 9.3
(CVSS2#AV:N/AC:M/Au:N/C:C/I:C/A:C)";
  script_description(english:desc);
 
  script_category(ACT_GATHER_INFO);
  script_family(english:"Windows");
 
  script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc.");
 
  script_dependencies("mozilla_org_installed.nasl");
  script_require_keys("Mozilla/Thunderbird/Version");

  exit(0);
}


include("misc_func.inc");


ver = read_version_in_kb("Mozilla/Thunderbird/Version");
if (isnull(ver)) exit(0);

if (ver[0] == 2 && ver[1] == 0 && ver[2] == 0 && ver[3] < 9) 
  security_hole(get_kb_item("SMB/transport"));
