#
# (C) Tenable Network Security, Inc.
#


if (description)
{
  script_id(25242);
  script_version("$Revision: 1.5 $");

  script_cve_id("CVE-2007-2583", "CVE-2007-2691", "CVE-2007-2692", "CVE-2007-2693");
  script_bugtraq_id(23911, 24008, 24011, 24016);

  script_name(english:"MySQL 5.1 < 5.1.18 Multiple Vulnerabilities");
  script_summary(english:"Checks version of MySQL");

  desc = "
Synopsis :

The remote database server is affected by multiple vulnerabilities. 

Description :

The version of MySQL installed on the remote host reportedly is
affected by several issues :

  - Evaluation of an 'IN()' predicate with a decimal-valued
    argument causes a service crash.

  - A user can rename a table even though he does not have 
    DROP privileges.

  - If a stored routine is declared as 'SQL SECURITY INVOKER', 
    a user may be able to gain privileges by invoking that 
    routine.

  - A user with only ALTER privileges on a partitioned table
    can discover information about the table that should 
    require SELECT privileges.

See also :

http://bugs.mysql.com/bug.php?id=23675
http://bugs.mysql.com/bug.php?id=27515
http://bugs.mysql.com/bug.php?id=27337
http://dev.mysql.com/doc/refman/5.1/en/news-5-1-18.html

Solution :

Upgrade to MySQL version 5.1.18 or later.

Risk factor : 

Medium / CVSS Base Score : 6.0
(CVSS2#AV:N/AC:M/Au:S/C:P/I:P/A:P)";
  script_description(english:desc);
 
  script_category(ACT_GATHER_INFO);
  script_family(english:"Databases");

  script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc.");

  script_dependencies("find_service1.nasl");
  script_require_ports("Services/mysql", 3306);

  exit(0);
}


include("global_settings.inc");
include("mysql_func.inc");


# nb: banner checks of open-source software are prone to false-
#     positives so only run the check if reporting is paranoid.
if (report_paranoia < 2) exit(0);


port = get_kb_item("Services/mysql");
if (!port) port = 3306;
if (!get_tcp_port_state(port)) exit(0);

soc = open_sock_tcp(port);
if (!soc) exit(0);


if (mysql_open(soc:soc) == 1)
{
  ver = mysql_get_version();
  if (isnull(ver)) exit(0);

  if (ver =~ "^5\.1\.([0-9]($|[^0-9])|1[1-7]($|[^0-9]))")
  {
    report = string(
      desc,
      "\n\n",
      "Plugin output :\n",
      "\n",
      "The remote MySQL ", mysql_get_variant(), "'s version is :\n",
      "\n",
      "  ", ver, "\n"
    );
    security_warning(port:port, data:report);
  }
}
mysql_close();
