#
# (C) Tenable Network Security, Inc.
#


  desc = "
Synopsis :

The remote database server is affected by several issues. 

Description :

The version of MySQL Enterprise Server installed on the remote host
reportedly is affected by the following issues :

  - Using RENAME TABLE against a table with explicit DATA
    DIRECTORY and INDEX DIRECTORY options can be used to
    overwrite system table information. (Bug #32111).

  - ALTER VIEW retained the original DEFINER value, even 
    when altered by another user, which could allow that 
    user to gain the access rights of the view. (Bug
    #29908)

  - When using a FEDERATED table, the local server can be 
    forced to crash if the remote server returns a result 
    with fewer columns than expected. (Bug #29801)

See also :

http://bugs.mysql.com/32111
http://bugs.mysql.com/29908
http://bugs.mysql.com/29801
http://dev.mysql.com/doc/refman/5.0/en/releasenotes-es-5-0-52.html

Solution :

Upgrade to MySQL Enterprise Server version 5.0.52 or later. 

Risk factor :

Medium / CVSS Base Score : 4.6
(CVSS2#AV:N/AC:H/Au:S/C:P/I:P/A:P)";


if (description)
{
  script_id(29346);
  script_version("$Revision: 1.1 $");

  script_cve_id("CVE-2007-5969", "CVE-2007-6303", "CVE-2007-6304");
  script_bugtraq_id(26765, 26832);

  script_name(english:"MySQL Enterprise Server < 5.0.52 Multiple Vulnerabilities");
  script_summary(english:"Checks version of MySQL Enterprise Server");

  script_description(english:desc);
 
  script_category(ACT_GATHER_INFO);
  script_family(english:"Databases");

  script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc.");

  script_dependencies("find_service1.nasl");
  script_require_ports("Services/mysql", 3306);

  exit(0);
}


include("global_settings.inc");
include("mysql_func.inc");


# nb: banner checks of open-source software are prone to false-
#     positives so only run the check if reporting is paranoid.
if (report_paranoia < 2) exit(0);


port = get_kb_item("Services/mysql");
if (!port) port = 3306;
if (!get_tcp_port_state(port)) exit(0);

soc = open_sock_tcp(port);
if (!soc) exit(0);


if (mysql_open(soc:soc) == 1)
{
  variant = mysql_get_variant();
  ver = mysql_get_version();

  if ("Enterprise " >< variant && ver =~ "^5\.0\.([0-9]|[1-4][0-9]|5[01])($|[^0-9])")
  {
    report = string(
      desc,
      "\n\n",
      "Plugin output :\n",
      "\n",
      "The remote MySQL ", variant, "'s version is :\n",
      "\n",
      "  ", ver, "\n"
    );
    security_warning(port:port, data:report);
  }
}
mysql_close();
