# netscaler_web_login.nasl
# GPLv2
#
# History:
#
# 1.00, 11/21/07
# - Initial release


if (description)
    {
    script_id(29223);
    script_version("$Revision: 1.1 $");
    name["english"]="NetScaler web management login";
    desc["english"]="
Synopsis :

It is possible to log into the remote web management interface. 

Description :

Nessus successfully logged into the remote Citrix NetScaler web
management interface using the supplied credentials and stored the
authentication cookie for later use. 

Risk factor :

None";
    summary["english"]="Logs into NetScaler web management interface";
    family["english"]="Settings";
    script_name(english:name["english"]);
    script_description(english:desc["english"]);
    script_summary(english:summary["english"]);
    script_family(english:family["english"]);
    script_category(ACT_GATHER_INFO);
    script_copyright(english:"This script is Copyright (c) 2007 nnposter");
    script_dependencies("logins.nasl","netscaler_web_detect.nasl");
    script_require_keys("www/netscaler","http/login");
    script_require_ports("Services/www",80);
    exit(0);
    }


if (!get_kb_item("www/netscaler")) exit(0);
if (!get_kb_item("http/login"))    exit(0);


include("url_func.inc");
include("http_func.inc");
include("http_keepalive.inc");


port=get_http_port(default:80);
if (!get_tcp_port_state(port) || !get_kb_item("www/netscaler/"+port))
    exit(0);

url="/ws/login.pl?"
    + "username="+urlencode(str:get_kb_item("http/login"))
    +"&password="+urlencode(str:get_kb_item("http/password"))
    +"&appselect=stat";

resp=http_keepalive_send_recv(port:port,
                              data:http_get(item:url,port:port),
                              embedded:TRUE);
if (!resp) exit(0);

cookie=egrep(pattern:"^Set-Cookie:",string:resp,icase:TRUE);
if (!cookie) exit(0);

cookie=ereg_replace(string:cookie,pattern:'^Set-',replace:" ",icase:TRUE);
cookie=ereg_replace(string:cookie,pattern:';[^\r\n]*',replace:";",icase:TRUE);
cookie=ereg_replace(string:cookie,pattern:'\r\nSet-Cookie: *',replace:" ",icase:TRUE);
cookie=ereg_replace(string:cookie,pattern:'; *(\r\n)',replace:"\1",icase:TRUE);
if (cookie!~" ns1=.* ns2=") exit(0);

set_kb_item(name:"/tmp/http/auth/"+port,value:cookie);
security_note(port);
