#
# (C) Tenable Network Security, Inc.
#


if (description)
{
  script_id(31343);
  script_version("$Revision: 1.1 $");

  script_name(english:"Netscape Browser No Longer Supported");
  script_summary(english:"Checks if Netscape is installed");

  desc = "
Synopsis :

The remote Windows host contains a web browser that is no longer
supported. 

Description :

Netscape Navigator or Netscape Browser is installed on the remote
host.  Official support for all Netscape client products, including
its browser, ended as of March 1st, 2008.  As a result, the web
browser on the remote host may contain critical vulnerabilities. 

See also :

http://blog.netscape.com/2007/12/28/end-of-support-for-netscape-web-browsers/

Solution :

Switch to another browser, such as Mozilla Firefox, which the Netscape
Team recommends. 

Risk factor :

High / CVSS Base Score : 9.3
(CVSS2#AV:N/AC:M/Au:N/C:C/I:C/A:C)";
  script_description(english:desc);
 
  script_category(ACT_GATHER_INFO);
  script_family(english:"Windows");
 
  script_copyright(english:"This script is Copyright (C) 2008 Tenable Network Security, Inc.");
 
  script_dependencies("netscape_browser_detect.nasl");
  script_require_keys("SMB/Netscape/installed");

  exit(0);
}


if (get_kb_item("SMB/Netscape/installed")) 
  security_hole(get_kb_item("SMB/transport"));
