#
# (C) Tenable Network Security
#


if (description) {
  script_id(18257);
  script_version("$Revision: 1.12 $");

  script_cve_id("CVE-2005-1009", "CVE-2005-1547");
  script_bugtraq_id(12967, 13594, 13618);
  script_xref(name:"OSVDB", value:"16602");

  name["english"] = "BakBone NetVault Remote Heap Overflow Vulnerabilities";
  script_name(english:name["english"]);
 
  desc["english"] = "
Synopsis :

The remote backup server is affected by multiple overflow flaws. 

Description :

The installed version of BakBone NetVault on the remote host suffers
from two remote heap buffer overflow vulnerabilities.  An attacker may
be able to exploit this flaw and execute arbitrary code with SYSTEM
privileges on the affected machine. 

See also : 

http://www.hat-squad.com/en/000164.html
http://archives.neohapsis.com/archives/bugtraq/2005-05/0133.html
http://archives.neohapsis.com/archives/bugtraq/2005-05/0167.html
http://www.bakbone.com/docs/NetVault_Release_Notes_(712).pdf
http://www.bakbone.com/docs/NetVault_Release_Notes_(731).pdf

Solution : 

Upgrade to BackBone NetVault 7.1.2 / 7.3.1 or later.

Risk factor : 

Critical / CVSS Base Score : 10.0
(CVSS2#AV:N/AC:L/Au:N/C:C/I:C/A:C)";
  script_description(english:desc["english"]);
 
  summary["english"] = "Checks for remote heap overflow vulnerabilities in BakBone NetVault";
  script_summary(english:summary["english"]);

  script_category(ACT_GATHER_INFO);
  script_family(english:"Gain root remotely");

  script_copyright(english:"This script is Copyright (C) 2005-2007 Tenable Network Security");

  script_dependencies("netvault_detect.nasl");
  script_require_ports("Services/nvpmgr");

  exit(0);
}


port = get_kb_item("Services/nvpmgr");
if (!get_port_state(port)) exit(0);


# Get the version number of NetVault on the remote.
nvver = get_kb_item("NetVault/"+port+"/NVVersion");
nvbuild = get_kb_item("NetVault/"+port+"/NVBuild");
if (isnull(nvver) || isnull(nvbuild)) exit(0);

ver = string(nvver[0], ".", nvver[2], nvver[3], " Build ", nvbuild);
if (ver =~ "^(6\.|7\.(0\.|1\.[01]|3\.0))") security_hole(port);
