#
# (C) Tenable Network Security
#


if (description)
{
  script_id(23786);
  script_version("$Revision: 1.3 $");

  script_name(english:"Novell ZenWorks Asset Management Server Detection");
  script_summary(english:"Detects a Novell ZenWorks Asset Management Server");

  desc = "
Synopsis :

A management server is listening on the remote host. 

Description :

The remote host is running a collection client service from Novell ZenWorks
Asset Management Server, a software and network management solution.

See also :

http://www.novell.com/products/zenworks/assetmanagement/overview.html

Risk factor :

None";
  script_description(english:desc);

  script_category(ACT_GATHER_INFO);
  script_family(english:"Service detection");

  script_copyright(english:"This script is Copyright (C) 2006 Tenable Network Security");

  script_dependencies("find_service1.nasl");
  script_require_ports("Services/unknown", 7461);

  exit(0);
}

include ("byte_func.inc");
include ("misc_func.inc");

set_byte_order(BYTE_ORDER_LITTLE_ENDIAN);

port = 7461;

if (!get_tcp_port_state(port))
  exit(0);

soc = open_sock_tcp (port);
if (!soc)
  exit(0);


req = mkbyte (0x00) + crap(data:raw_string(0), length:0x0d) + mkword (0) +
	mkword (0xfe) +
	mkword (0x0) +
	mkdword (0x40000);

send(socket:soc, data:req);
res = recv (socket:soc, length:4096);

if ("TS.Census module" >< res)
{
  # Register and report the service.
  register_service(port:port, ipproto:"tcp", proto:"novell_zenworks_asset");
  set_kb_item ("Novell/AMCC");
  security_note(port);
}
