#
# (C) Tenable Network Security
#

if(description)
{
 script_id(23787);
 script_version("$Revision: 1.4 $");

 script_cve_id("CVE-2006-6299");
 script_bugtraq_id(21395, 21400);
 script_xref(name:"OSVDB", value:"31352");
 script_xref(name:"OSVDB", value:"31353");

 name["english"] = "Novell ZENworks Asset Management Collection Client Heap Overflow Vulnerability";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

Arbitrary code can be executed on the remote host.

Description :

The remote host is running Novell ZENworks Asset (or Inventory)
Management, a remote desktop and network management software. 

The remote version of this software is vulnerable to multiple heap
overflow vulnerabilities which may be exploited by an attacker to
execute arbitrary code on the remote host with SYSTEM privileges. 

Solution :

http://support.novell.com/cgi-bin/search/searchtid.cgi?/2974824.htm

Risk factor :

Critical / CVSS Base Score : 10.0
(CVSS2#AV:N/AC:L/Au:N/C:C/I:C/A:C)";

 script_description(english:desc["english"]);
 
 summary["english"] = "Determines if ZENWorks Asset Management is vulnerable to an Heap Overflow";

 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2006-2008 Tenable Network Security");
 family["english"] = "Gain root remotely";
 script_family(english:family["english"]);
 script_dependencies("novell_asset_management_detect.nasl");
 script_require_ports(7461);
 exit(0);
}

include ("byte_func.inc");

if (!get_kb_item("Novell/AMCC"))
  exit (0);

set_byte_order(BYTE_ORDER_LITTLE_ENDIAN);

port = 7461;

if (!get_tcp_port_state(port))
  exit(0);

soc = open_sock_tcp (port);
if (!soc)
  exit(0);


req = mkbyte (0x00) + crap(data:raw_string(0), length:0x0d) + mkword (0) +
	mkword (0xfe) +
	mkword (0x0) +
	mkdword (0x40001);  # new check on the length (<= 0x40000)

send(socket:soc, data:req);
res = recv (socket:soc, length:4096);


if ("TS.Census module" >< res)
{
  security_hole(port);
}
