#
# This script was written by Tenable Network Security
#
# See the Nessus Scripts License for details
#


 desc["english"] = "
Synopsis :

The remote office suite is not up to date.

Description :

The remote Microsoft Office has no service pack or the installed one is
no longer supported.

Solution :

Install the latest service pack.

Risk factor : 

High / CVSS Base Score : 9.3
(CVSS2#AV:N/AC:M/Au:N/C:C/I:C/A:C)";

if(description)
{
 script_id(27525);
 script_version ("$Revision: 1.2 $");
 
 name["english"] = "Microsoft Office service pack not up to date";
 
 script_name(english:name["english"]);
 
 script_description(english:desc["english"]);
 
 summary["english"] = "Determines the remote Office SP";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc");
 family["english"] = "Windows";
 script_family(english:family["english"]);
 
 script_dependencies("office_installed.nasl");
 script_require_keys("SMB/Office/Version");
 exit(0);
}

# First checks Windows

office_sp["2000"] = 3;
office_sp["XP"] = 3;
office_sp["2003"] = 3;
office_sp["2007"] = 0;

office_min_sp["2000"] = 3;
office_min_sp["XP"] = 3;
office_min_sp["2003"] = 2;
office_min_sp["2007"] = 0;

report = NULL;

version = get_kb_item("SMB/Office/Version"); 
sp = get_kb_item("SMB/Office/SP");

if (!version || !sp)
  exit(0);

if (sp == 0)
  report = "no service pack";
else
  report = string("Service Pack ", sp);

if (sp < office_min_sp[version])
{
 report = string (desc["english"],
		"\n\nPlugin output :\n\n",
		"The remote Microsoft Office ", version, " system has ", report , " applied.\n",
		"The system should have Service Pack ", office_sp[version], " installed.");

 security_hole(data:report, port:port);
}
