#
# (C) Tenable Network Security
#


if (description) {
  script_id(29249);
  script_version("$Revision: 1.2 $");

  script_cve_id("CVE-2007-6204");
  script_bugtraq_id(26741);
  script_xref(name:"OSVDB", value:"39529");
  script_xref(name:"OSVDB", value:"39530");
  script_xref(name:"OSVDB", value:"39531");
  script_xref(name:"OSVDB", value:"39532");

  name["english"] = "HP OpenView Network Node Manager CGI Buffer Overflow Vulnerabilities";
  script_name(english:name["english"]);
 
  desc["english"] = "
Synopsis :

The remote web server contains multiple CGI scripts that allows
execution of arbitrary commands. 

Description :

The remote version of HP OpenView Network Node Manager fails to
sanitize user-supplied input to various parameters used in the
'Openview5', 'snmpview', 'ovlogin' scripts before using it. 

By sending too long parameters an attacker would be able to produce a
stack based overflow and exploit it to execute code on the remote host
with the web server privileges. 

Bad permissions on the web server directory allow a full system
compromise. 

See also : 

http://www.zerodayinitiative.com/advisories/ZDI-07-071.html
http://support.openview.hp.com/patches/patch_index.jsp

Solution :

Apply patched referenced in the vendor advisory above. 

Risk factor : 

High / CVSS Base Score : 7.5
(CVSS2#AV:N/AC:L/Au:N/C:P/I:P/A:P)";
  script_description(english:desc["english"]);
 
  summary["english"] = "Checks for multiple remote command execution vulnerabilities in HP OpenView Network Node Manager";
  script_summary(english:summary["english"]);
 
  script_category(ACT_ATTACK);
  script_family(english:"CGI abuses");

  script_copyright(english:"This script is Copyright (C) 2007-2008 Tenable Network Security");

  script_dependencies("http_version.nasl");
  script_require_ports("Services/www", 80, 3443);

  exit(0);
}


include("http_func.inc");
include("http_keepalive.inc");

port = get_http_port(default:80);
if (!get_port_state(port)) exit(0);
if (get_kb_item("Services/www/" + port + "/embedded")) exit(0);


req = http_get(
  item:string("/OvCgi/OpenView5.exe"),
  port:port
);
res = http_keepalive_send_recv(port:port, data:req, bodyonly:FALSE);
if (res == NULL) exit(0);

if ("<TITLE>HP OpenView Web</TITLE>" >< res && 
   egrep(pattern:"Information: \(c\) Copyright [0-9]+-[0-9]+ Hewlett-Packard Development Company, LP", string:res) )
{
 version = ereg_replace(pattern:".*Information: \(c\) Copyright [0-9]+-([0-9]+) Hewlett-Packard Development Company, LP.*", string:res, replace:"\1");
 version = int(version);

 if (version < 2007)
  security_hole(port);
}
