#
# (C) Tenable Network Security
#


if (description)
{
  script_id(23977);
  script_version("$Revision: 1.5 $");

  script_cve_id("CVE-2007-0126", "CVE-2007-0127");
  script_bugtraq_id(21882);
  script_xref(name:"OSVDB", value:"31574");
  script_xref(name:"OSVDB", value:"31575");

  script_name(english:"Opera < 9.10 Multiple Vulnerabilities");
  script_summary(english:"Checks version number of Opera");

  desc = "
Synopsis :

The remote host contains a web browser that is susceptible to
multiple issues. 

Description :

The version of Opera installed on the remote host reportedly contains
a heap overflow vulnerability that can be triggered when processing
the DHT marker in a specially-crafted JPEG image to crash the browser
or possibly allow execution of arbitrary code on the affected host. 

In addition, another flaw in Opera's createSVGTransformFromMatrix
object typecasting may lead to a browser crash or arbitrary code
execution if support for Javascript is enabled. 

See also :

http://labs.idefense.com/intelligence/vulnerabilities/display.php?id=458
http://labs.idefense.com/intelligence/vulnerabilities/display.php?id=457
http://www.securityfocus.com/archive/1/456053
http://www.securityfocus.com/archive/1/456066
http://www.opera.com/support/search/supsearch.dml?index=851
http://www.opera.com/support/search/supsearch.dml?index=852

Solution :

Upgrade to Opera version 9.10 or later. 

Risk factor :

High / CVSS Base Score : 9.3
(CVSS2#AV:N/AC:M/Au:N/C:C/I:C/A:C)";
  script_description(english:desc);

  script_category(ACT_GATHER_INFO);
  script_family(english:"Windows");

  script_copyright(english:"This script is Copyright (C) 2007-2008 Tenable Network Security");

  script_dependencies("opera_installed.nasl");
  script_require_keys("SMB/Opera/Version");

  exit(0);
}


ver = get_kb_item("SMB/Opera/Version");
if (ver && ver =~ "^9\.0[0-9]($|[^0-9])")
  security_hole(get_kb_item("SMB/transport"));
