#
# (C) Tenable Network Security, Inc.
#


if (description)
{
  script_id(25036);
  script_version("$Revision: 1.4 $");

  script_cve_id("CVE-2007-1114", "CVE-2007-1115", "CVE-2007-1563");
  script_bugtraq_id(22701, 23089);
  script_xref(name:"OSVDB", value:"32118");

  script_name(english:"Opera < 9.20 Multiple Vulnerabilities");
  script_summary(english:"Checks version number of Opera");

  desc = "
Synopsis :

The remote host contains a web browser which is susceptible to
multiple issues. 

Description :

The version of Opera installed on the remote host reportedly may allow
a remote attacker to bypass XSS filters because it renders a web page
without a defined charset with the charset of the parent page. 

In addition, its FTP implementation can be leveraged by remote
attackers to force the client to connect to arbitrary servers via FTP
PASV responses. 

See also :

http://bindshell.net/papers/ftppasv
http://www.hardened-php.net/advisory_032007.142.html
http://www.opera.com/support/search/view/855/

Solution :

Upgrade to Opera version 9.20 or later. 

Risk factor :

Medium / CVSS Base Score : 6.8
(CVSS2#AV:N/AC:M/Au:N/C:P/I:P/A:P)";
  script_description(english:desc);

  script_category(ACT_GATHER_INFO);
  script_family(english:"Windows");

  script_copyright(english:"This script is Copyright (C) 2007-2008 Tenable Network Security, Inc.");

  script_dependencies("opera_installed.nasl");
  script_require_keys("SMB/Opera/Version");

  exit(0);
}


ver = get_kb_item("SMB/Opera/Version");
if (ver && ver =~ "^9\.[01][0-9]($|[^0-9])")
  security_warning(get_kb_item("SMB/transport"));
