#
# (C) Tenable Network Security, Inc.
#


if (description)
{
  script_id(27506);
  script_version("$Revision: 1.4 $");

  script_cve_id("CVE-2007-5540", "CVE-2007-5541");
  script_bugtraq_id(26100, 26102);
  script_xref(name:"OSVDB", value:"38126");
  script_xref(name:"OSVDB", value:"38127");

  script_name(english:"Opera < 9.24 Multiple Vulnerabilities");
  script_summary(english:"Checks version number of Opera");

  desc = "
Synopsis :

The remote host contains a web browser that is affected by two
vulnerabilities. 

Description :

The version of Opera installed on the remote host reportedly may allow
for arbitrary code execution if it has been configured to use an
external news reader or email client and a user views a
specially-crafted web page. 

In addition, it may also allow a script to bypass the same-origin
policy and overwrite functions on pages from other domains when
processing frames from different web sites, which can be leveraged to
conduct cross-site scripting attacks. 

See also :

http://www.opera.com/support/search/view/866/
http://www.opera.com/support/search/view/867/
http://www.opera.com/docs/changelogs/windows/924/

Solution :

Upgrade to Opera version 9.24 or later. 

Risk factor :

High / CVSS Base Score : 9.3
(CVSS2#AV:N/AC:M/Au:N/C:C/I:C/A:C)";
  script_description(english:desc);

  script_category(ACT_GATHER_INFO);
  script_family(english:"Windows");

  script_copyright(english:"This script is Copyright (C) 2007-2008 Tenable Network Security, Inc.");

  script_dependencies("opera_installed.nasl");
  script_require_keys("SMB/Opera/Version");

  exit(0);
}


ver = get_kb_item("SMB/Opera/Version");
if (ver && ver =~ "^([0-8]\.|9\.([01][0-9]|2[0-3])($|[^0-9]))")
  security_hole(get_kb_item("SMB/transport"));
