#
# (C) Tenable Network Security, Inc.
#


if (description)
{
  script_id(29742);
  script_version("$Revision: 1.2 $");

  script_cve_id(
    "CVE-2007-6520", 
    "CVE-2007-6521", 
    "CVE-2007-6522", 
    "CVE-2007-6523", 
    "CVE-2007-6524"
  );
  script_bugtraq_id(26721, 26937);

  script_name(english:"Opera < 9.25 Multiple Vulnerabilities");
  script_summary(english:"Checks version number of Opera");

  desc = "
Synopsis :

The remote host contains a web browser that is affected by several
issues. 

Description :

The version of Opera installed on the remote host reportedly is
affected by several issues, including one in which TLS certificates
could be used to execute arbitrary code. 

See also :

http://www.opera.com/support/search/view/875/
http://www.opera.com/docs/changelogs/windows/925/

Solution :

Upgrade to Opera version 9.25 or later. 

Risk factor :

High / CVSS Base Score : 9.3
(CVSS2#AV:N/AC:M/Au:N/C:C/I:C/A:C)";
  script_description(english:desc);

  script_category(ACT_GATHER_INFO);
  script_family(english:"Windows");

  script_copyright(english:"This script is Copyright (C) 2007-2008 Tenable Network Security, Inc.");

  script_dependencies("opera_installed.nasl");
  script_require_keys("SMB/Opera/Version");

  exit(0);
}


ver = get_kb_item("SMB/Opera/Version");
if (ver && ver =~ "^([0-8]\.|9\.([01][0-9]|2[0-4])($|[^0-9]))")
  security_hole(get_kb_item("SMB/transport"));
