#
# (C) Tenable Network Security, Inc.
#

if (description)
{
  script_id(25335);
  script_version("$Revision: 1.2 $");

  name["english"] = "OS Identification : Linux Distribution";
  script_name(english:name["english"]);

  desc["english"] = "
This script attempts to identify the Operating System type and 
version by looking at some files on the remote operating system
(/etc/redhat-release on Red Hat, etc...)

Risk factor : None";

  script_description(english:desc["english"]);
 
  summary["english"] = "Determines the remote operating system";
  script_summary(english:summary["english"]);
 
  script_category(ACT_GATHER_INFO);
 
  script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
  family["english"] = "General";
  script_family(english:family["english"]);
  script_dependencies("ssh_get_info.nasl", "os_fingerprint_uname.nasl");
  script_require_keys("Host/OS/uname");
  exit(0);
}


kernel = get_kb_item("Host/OS/uname");
if ( ! kernel || "Linux Kernel" >!< kernel ) exit(0);

os = get_kb_item("Host/RedHat/release");
if ( ! os ) os = get_kb_item("Host/CentOS/release");
if ( ! os ) os = get_kb_item("Host/Mandrake/release");
if ( ! os ) {
	os = get_kb_item("Host/SuSE/release");
	if ( os ) os = "SuSE " + (os - "SUSE");
	}
if ( ! os ) os = get_kb_item("Host/Gentoo/release");
if ( ! os ) os = get_kb_item("Host/Slackware/release");
if ( ! os ) {
	os = get_kb_item("Host/Ubuntu/release");
	if ( os ) os = "Ubuntu " + os;
	}
if ( ! os ) {
	os = get_kb_item("Host/Debian/release");
	if ( os ) os = "Debian " + os;
	}

if ( os )
{
 os = chomp(os);
 set_kb_item(name:"Host/OS/LinuxDistribution", value:kernel +" on " + os);
 set_kb_item(name:"Host/OS/LinuxDistribution/Type", value:"general-purpose");
 set_kb_item(name:"Host/OS/LinuxDistribution/Confidence", value:100);
}

