#
# (C) Tenable Network Security, Inc.
#


  desc = "
Synopsis :

The remote web service is protected with default credentials. 

Description :

The remote host is running HP OpenView Client Configuration Manager
(OVCCM), a PC software configuration management application. 

The remote installation of OVCCM is configured to use default
credentials to control access.  Knowing these, an attacker can gain
control of the affected application. 

Solution :

Change the password for the 'admin' account by logging into OVCCM,
navigating to 'Configuration / Console Access', and editing the
'admin' account. 

Risk factor :

High / CVSS Base Score : 7.5
(CVSS2#AV:N/AC:L/Au:N/C:P/I:P/A:P)";


if (description)
{
  script_id(27802);
  script_version("$Revision: 1.1 $");

  script_name(english:"HP OpenView Client Configuration Manager Default Credentials");
  script_summary(english:"Tries to login to OVCCM with default credentials");

  script_description(english:desc);

  script_category(ACT_ATTACK);
  script_family(english:"CGI abuses");

  script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc.");

  script_dependencies("http_version.nasl");
  script_require_ports("Services/www", 3480);

  exit(0);
}


include("global_settings.inc");
include("http_func.inc");
include("http_keepalive.inc");


port = get_http_port(default:3480);
if (!get_port_state(port)) exit(0);


user = "admin";
pass = "secret";


# Check whether the login script exists.
url = "/ccm/console.tcl?";
req = http_get(item:url, port:port);
res = http_keepalive_send_recv(port:port, data:req, bodyonly:TRUE);
if (res == NULL) exit(0);


# If it does...
if ('<input name="user.id"' >< res)
{
  # Extract the session identifier.
  sid = NULL;
  pat = 'name="sessionId" value="([^"]+)">';
  matches = egrep(pattern:pat, string:res);
  if (matches)
  {
    foreach match (split(matches)) 
    {
      match = chomp(match);
      value = eregmatch(pattern:pat, string:match);
      if (!isnull(value))
      {
        sid = value[1];
        break;
      }
    }
  }
  if (isnull(sid))
  {
    if (log_verbosity > 1) debug_print("can't extract the session identifier!", level:0);
    exit(1);
  }

  # Try to log in.
  postdata = string(
    "user.id=", user, "&",
    "user.password=", pass, "&",
    "btnSignIn:btnCommandButton=Sign+In&",
    "login=1&",
    "sessionId=", sid, "&",
    "referal="
  );
  req = string(
    "POST ", url, " HTTP/1.1\r\n",
    "Host: ", get_host_name(), "\r\n",
    "User-Agent: ", get_kb_item("global_settings/http_user_agent"), "\r\n",
    "Content-Type: application/x-www-form-urlencoded\r\n",
    "Content-Length: ", strlen(postdata), "\r\n",
    "\r\n",
    postdata
  );
  res = http_keepalive_send_recv(port:port, data:req, bodyonly:FALSE);
  if (res == NULL) exit(0);

  # There's a problem if the admin cookie is set.
  if (
    string(';URL=?sessionId=', sid) >< res &&
    egrep(pattern:"Set-Cookie: user.token=[^;]+;", string:res)
  )
  {
    report = string(
      desc,
      "\n\n",
      "Plugin output :\n",
      "\n",
      "Nessus was able to gain access using the following credentials :\n",
      "\n",
      "  User     : ", user, "\n",
      "  Password : ", pass, "\n"
    );
    security_hole(port:port, data:report);
  }
}
