#
# (C) Tenable Network Security, Inc.
#


  desc = "
Synopsis :

The remote web server is affected by a buffer overflow vulnerability. 

Description :

The version of PeerCast installed on the remote host fails to check
the length of user-supplied data in its 'handshakeHTTP' function in
'servhs.cpp' before copying it to the 'loginPassword' and 'loginMount'
heap-based buffers.  An unauthenticated attacker can leverage this
issue to crash the affected application or execute arbitrary code on
the remote host, subject to the privileges under which PeerCast
operates. 

See also :

http://www.securityfocus.com/archive/1/485199/30/0/threaded

Solution :

Upgrade to PeerCast version 0.1218 or later.

Risk factor : 

High / CVSS Base Score : 7.5
(CVSS2#AV:N/AC:L/Au:N/C:P/I:P/A:P)";


if (description)
{
  script_id(29726);
  script_version("$Revision: 1.3 $");

  script_cve_id("CVE-2007-6454");
  script_bugtraq_id(26899);
  script_xref(name:"OSVDB", value:"40250");

  script_name(english:"PeerCast handshakeHTTP Buffer Overflow Vulnerability");
  script_summary(english:"Checks for overflow in PeerCast web server");
 
  script_description(english:desc);

  script_category(ACT_MIXED_ATTACK);
  script_family(english:"Gain a shell remotely");

  script_copyright(english:"This script is Copyright (C) 2007-2008 Tenable Network Security, Inc.");

  script_dependencies("peercast_installed.nasl");
  script_require_keys("PeerCast/installed");
  script_require_ports("Services/www", 7144, 7145);

  exit(0);
}


if (!get_kb_item("PeerCast/installed")) exit(0);


include("http_func.inc");
include("http_keepalive.inc");
include("global_settings.inc");


list = get_kb_list("PeerCast/*/version");
if (isnull(list)) exit(0);

foreach key (keys(list))
{
  port = key - "PeerCast/" - "/version";
  ver = list[key];

  if (get_port_state(port))
  {
    # If safe checks are enabled...
    if (safe_checks())
    {
      # Check the version.
      vuln = FALSE;

      if (ver =~ "^[0-9]\.[0-9]+$")
      {
        iver = split(ver, sep:'.', keep:FALSE);
        for (i=0; i<max_index(iver); i++)
          iver[i] = int(iver[i]);

        if (iver[0] == 0 && iver[1] < 1218) vuln = TRUE;
      }
      else if (report_paranoia > 1) vuln = TRUE;

      if (vuln)
      {
       report = string(
          desc,
          "\n\n",
          "Plugin output :\n",
          "\n",
          "According to its Server response header, the version of PeerCast on the\n",
          "remote host is :\n",
          "\n",
          "  ", ver, "\n"
        );
        security_hole(port:port, data:report);
        break;
      }
    }
    # Otherwise...
    else
    {
      # Make sure the server's up.
      soc = http_open_socket(port);
      if (!soc || http_is_dead(port:port)) exit(1);

      # Try to crash it.
      req = string("SOURCE ", crap(data:"A", length:165), "\r\n\r\n");
      send(socket:soc, data:req);
      res = http_recv(socket:soc);
      http_close_socket(soc);

      # There's a problem if the server's down.
      if (http_is_dead(port:port))
      {
        security_hole(port);
        exit(0);
      }
    }
  }
}
