#
# (C) Tenable Network Security, Inc.
#


if (description)
{
  script_id(29833);
  script_version("$Revision: 1.1 $");

  script_cve_id("CVE-2007-3378");
  script_bugtraq_id(24661, 25498);

  script_name(english:"PHP < 4.4.8 Multiple Vulnerabilities");
  script_summary(english:"Checks version of PHP");
 
  desc = "
Synopsis :

The remote web server uses a version of PHP that is affected by
multiple issues. 

Description :

According to its banner, the version of PHP installed on the remote
host is older than 4.4.8.  Such versions may be affected by several
issues, including integer overflows involving the 'chunk_split',
'strcspn', and 'strspn' functions, and 'safe_mode' / 'open_basedir'
bypasses. 

See also :

http://www.php.net/releases/4_4_8.php

Solution :

Upgrade to PHP version 4.4.8 or later. 

Risk factor : 

High / CVSS Base Score : 7.5
(CVSS2#AV:N/AC:L/Au:N/C:P/I:P/A:P)";
  script_description(english:desc);
 
  script_category(ACT_GATHER_INFO);
  script_family(english:"CGI abuses");

  script_copyright(english:"This script is Copyright (C) 2008 Tenable Network Security, Inc.");

  script_dependencies("http_version.nasl");
  script_require_ports("Services/www", 80);

  exit(0);
}


include("backport.inc");
include("global_settings.inc");
include("http_func.inc");


# nb: banner checks of open-source software are prone to false-
#     positives so only run the check if reporting is paranoid.
if (report_paranoia < 2) exit(0);


port = get_http_port(default:80);
if (!get_port_state(port)) exit(0);
if (!can_host_php(port:port)) exit(0);


banner = get_http_banner(port:port);
if (banner)
{
  ver = get_php_version(banner:banner);
  if (ver && ver =~ "PHP/(3\.|4\.([0-3]\.|4\.[0-7]($|[^0-9])))")
    security_hole(port);
}
