#
# (C) Tenable Network Security, Inc.
#


if (description)
{
  script_id(24907);
  script_version("$Revision: 1.9 $");
  script_cve_id(
    "CVE-2006-6383",
    "CVE-2007-0905",
    "CVE-2007-0906",
    "CVE-2007-0907",
    "CVE-2007-0908",
    "CVE-2007-0909",
    "CVE-2007-0910",
    "CVE-2007-1376",
    "CVE-2007-1380",
    "CVE-2007-1453",
    "CVE-2007-1700",
    "CVE-2007-1701",
    "CVE-2007-1824",
    "CVE-2007-1825",
    "CVE-2007-1884",
    "CVE-2007-1885",
    "CVE-2007-1886",
    "CVE-2007-1887",
    "CVE-2007-1890"
  );
  script_bugtraq_id(
    21508, 
    22496, 
    22805,
    22806,
    22862,
    22922,
    23119,
    23120,
    23219,
    23233, 
    23234, 
    23235, 
    23236, 
    23237, 
    23238
  );
  script_xref(name:"OSVDB", value:"32776");
  script_xref(name:"OSVDB", value:"32781");
  script_xref(name:"OSVDB", value:"33955");
  script_xref(name:"OSVDB", value:"34767");

  script_name(english:"PHP < 5.2.1 Multiple Vulnerabilities");
  script_summary(english:"Checks version of PHP");
 
  desc = "
Synopsis :

The remote web server uses a version of PHP that is affected by
multiple flaws. 

Description :

According to its banner, the version of PHP installed on the remote
host is older than 5.2.1.  Such versions may be affected by several
issues, including buffer overflows, format string vulnerabilities,
arbitrary code execution, 'safe_mode' and 'open_basedir' bypasses, and
clobbering of super-globals. 

See also :

http://www.php.net/releases/5_2_1.php

Solution :

Upgrade to PHP version 5.2.1 or later. 

Risk factor : 

High / CVSS Base Score : 7.5
(CVSS2#AV:N/AC:L/Au:N/C:P/I:P/A:P)";
  script_description(english:desc);
 
  script_category(ACT_GATHER_INFO);
  script_family(english:"CGI abuses");

  script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc.");

  script_dependencies("http_version.nasl");
  script_require_ports("Services/www", 80);

  exit(0);
}


include("backport.inc");
include("http_func.inc");


port = get_http_port(default:80);
if (!get_port_state(port)) exit(0);
if (!can_host_php(port:port)) exit(0);


banner = get_http_banner(port:port);
if (banner)
{
  ver = get_php_version(banner:banner);
  if (ver && ver =~ "PHP/5\.([01]\.|2\.0($|[^0-9]))")
    security_hole(port);
}
