#
# (C) Tenable Network Security, Inc.
#


if (description)
{
  script_id(25971);
  script_version("$Revision: 1.2 $");

  script_cve_id("CVE-2007-2872", "CVE-2007-3378", "CVE-2007-3806");
  script_bugtraq_id(24661, 24261, 24922, 25498);

  script_name(english:"PHP < 5.2.4 Multiple Vulnerabilities");
  script_summary(english:"Checks version of PHP");
 
  desc = "
Synopsis :

The remote web server uses a version of PHP that is affected by
multiple flaws. 

Description :

According to its banner, the version of PHP installed on the remote
host is older than 5.2.4.  Such versions may be affected by various
issues, including but not limited to several overflows.

See also :

http://www.php.net/releases/5_2_4.php

Solution :

Upgrade to PHP version 5.2.4 or later. 

Risk factor : 

High / CVSS Base Score : 7.5
(CVSS2#AV:N/AC:L/Au:N/C:P/I:P/A:P)";
  script_description(english:desc);
 
  script_category(ACT_GATHER_INFO);
  script_family(english:"CGI abuses");

  script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc.");

  script_dependencies("http_version.nasl");
  script_require_ports("Services/www", 80);

  exit(0);
}


include("backport.inc");
include("http_func.inc");


port = get_http_port(default:80);
if (!get_port_state(port)) exit(0);
if (!can_host_php(port:port)) exit(0);


banner = get_http_banner(port:port);
if (banner)
{
  ver = get_php_version(banner:banner);
  if (ver && ver =~ "PHP/5\.([01]\.|2\.[0-3]($|[^0-9]))")
    security_hole(port);
}
