#
# (C) Tenable Network Security
#


if (description)
{
  script_id(23968);
  script_version("$Revision: 1.4 $");

  script_cve_id(
    "CVE-2006-4758",
    "CVE-2006-6421",
    "CVE-2006-6839",
    "CVE-2006-6840",
    "CVE-2006-6841"
  );
  script_bugtraq_id(20347, 21806, 22001);
  script_xref(name:"OSVDB", value:"31859");
  script_xref(name:"OSVDB", value:"35441");
  script_xref(name:"OSVDB", value:"35442");
  script_xref(name:"OSVDB", value:"35443");

  script_name(english:"phpBB < 2.0.22 Multiple Vulnerabilities");
  script_summary(english:"Tries to pass a 'bad' redirect in via phpBB");

  desc = "
Synopsis :

The remote web server contains a PHP application that is affected by
multiple vulnerabilities. 

Description :

The version of phpBB installed on the remote host fails to properly
block 'bad' redirection targets.  In addition, it reportedly contains
a non-persistent cross-site scripting flaw involving its private
messaging functionality and several other issues.  At a minimum, a
remote attacker can leverage these flaws to launch cross-site
scripting attacks against the affected application. 

See also :

http://www.phpbb.com/phpBB/viewtopic.php?f=14&t=489624

Solution :

Upgrade to phpBB 2.0.22 or later. 

Risk factor :

Critical / CVSS Base Score : 10.0
(CVSS2#AV:N/AC:L/Au:N/C:C/I:C/A:C)";
  script_description(english:desc);

  script_category(ACT_ATTACK);
  script_family(english:"CGI abuses");

  script_copyright(english:"This script is Copyright (C) 2007-2008 Tenable Network Security");

  script_dependencies("phpbb_detect.nasl");
  script_exclude_keys("Settings/disable_cgi_scanning");
  script_require_ports("Services/www", 80);

  exit(0);
}


include("http_func.inc");
include("http_keepalive.inc");


port = get_http_port(default:80);
if (!get_port_state(port)) exit(0);
if (!can_host_php(port:port)) exit(0);


# Test an install.
install = get_kb_item(string("www/", port, "/phpBB"));
if (isnull(install)) exit(0);
matches = eregmatch(string:install, pattern:"^(.+) under (/.*)$");
if (!isnull(matches))
{
  dir = matches[2];

  # Check whether the affected script exists.
  url = string(dir, "/login.php");
  req = http_get(item:url, port:port);
  res = http_keepalive_send_recv(port:port, data:req, bodyonly:TRUE);
  if (res == NULL) exit(0);

  # If it does...
  if ('form action="login.php?sid=' >< res)
  {
    # Try to pass in a "bad" redirection target.
    redir = string("/", SCRIPT_NAME, ";url=", unixtime());
    postdata = string(
      "username=&",
      "password=&",
      "redirect=", redir, "&",
      "login=Log+in"
    );
    req = string(
      "POST ", url, " HTTP/1.1\r\n",
      "Host: ", get_host_name(), "\r\n",
      "User-Agent: ", get_kb_item("global_settings/http_user_agent"), "\r\n",
      "Content-Type: application/x-www-form-urlencoded\r\n",
      "Content-Length: ", strlen(postdata), "\r\n",
      "\r\n",
      postdata
    );
    res = http_keepalive_send_recv(port:port, data:req, bodyonly:TRUE);
    if (res == NULL) exit(0);

    # There's a problem if the target was accepted.
    if (string('refresh" content="3;url=login.php?redirect=', redir, '">') >< res)
    {
      security_hole(port);
      exit(0);
    }
  }
}
