#
# (C) Tenable Network Security
#


if (description)
{
  script_id(24672);
  script_version("$Revision: 1.4 $");

  script_cve_id("CVE-2007-1032");
  script_xref(name:"OSVDB", value:"32603");

  script_name(english:"phpMyFAQ < 1.6.10 File Upload Vulnerability");
  script_summary(english:"Tries to bypass authentication with phpMyFAQ's ImageManager plugin");

  desc = "
Synopsis :

The remote web server contains a PHP application that is affected by
privilege escalation issues. 

Description :

The installation of phpMyFAQ on the remote host allows for bypassing
authentication or escalating privileges via the 'admin/attachment.php'
and 'admin/editor/plugins/ImageManager/images.php' scripts.  By
leveraging these issues, a remote attacker can upload files, possibly
even containing arbitary code, subject to the privileges of the web
server user id. 

Note that successful exploitation of these issues requires PHP's
'register_globals' setting to be enabled. 

See also :

http://www.phpmyfaq.de/advisory_2007-02-18.php

Solution :

Upgrade to phpMyFAQ 1.6.10 or later.

Risk factor :

Medium / CVSS Base Score : 6.8
(CVSS2#AV:N/AC:M/Au:N/C:P/I:P/A:P)";
  script_description(english:desc);

  script_category(ACT_ATTACK);
  script_family(english:"CGI abuses");

  script_copyright(english:"This script is Copyright (C) 2007-2008 Tenable Network Security");

  script_dependencies("phpmyfaq_detect.nasl");
  script_exclude_keys("Settings/disable_cgi_scanning");
  script_require_ports("Services/www", 80);

  exit(0);
}


include("http_func.inc");
include("http_keepalive.inc");
include("url_func.inc");


port = get_http_port(default:80);
if (!get_port_state(port)) exit(0);
if (!can_host_php(port:port)) exit(0);


# Test an install.
install = get_kb_item(string("www/", port, "/phpmyfaq"));
if (isnull(install)) exit(0);
matches = eregmatch(string:install, pattern:"^(.+) under (/.*)$");
if (!isnull(matches))
{
  dir = matches[2];

  # Check if we can bypass authentication.
  #
  # nb: we won't actually try to upload a file so that the attack 
  #     is not a destructive one.
  url = string(
    dir, "/admin/editor/plugins/ImageManager/images.php?",
    "auth=1&",
    "permission[addatt]=1"
  );
  req = http_get(item:url, port:port);
  res = http_keepalive_send_recv(port:port, data:req, bodyonly:TRUE);
  if (res == NULL) exit(0);

  # There's a problem if so.
  if (
    "<title>Image List" >< res &&
    "function editImage" >< res
  )
  {
    security_warning(port);
    exit(0);
  }
}
