#
# (C) Tenable Network Security
#


if (description) 
{
  script_id(24261);
  script_version("$Revision: 1.1 $");

  script_name(english:"PHProxy Detection");
  script_summary(english:"Checks for the presence of PHProxy");
 
 desc = "
Synopsis :

The remote web server contains an HTTP proxy written in PHP. 

Description :

The remote host is running PHProxy, a PHP-based HTTP proxy intended to
bypass firewall and other proxy restrictions. 

See also :

http://whitefyre.com/poxy/

Solution :

Make sure use of this program is in accordance with your corporate
security policy. 

Risk factor :

None";
  script_description(english:desc);
 
  script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");

  script_category(ACT_GATHER_INFO);
  script_family(english:"CGI abuses");
 
  script_dependencies("http_version.nasl");
  script_exclude_keys("Settings/disable_cgi_scanning");
  script_require_ports("Services/www", 80);

  exit(0);
}


include("global_settings.inc");
include("http_func.inc");
include("http_keepalive.inc");


port = get_http_port(default:80);
if (!get_port_state(port)) exit(0);
if (!can_host_php(port:port)) exit(0);


# Loop through directories.
if (thorough_tests) dirs = make_list("/phproxy", "/poxy", cgi_dirs());
else dirs = make_list(cgi_dirs());

installs = 0;
foreach dir (dirs) {
  res = http_get_cache(item:string(dir, "/index.php"), port:port);
  if (res == NULL) exit(0);

  # There's a problem if it's PHProxy.
  if
  (
    (
      "<title>PHProxy<" >< res ||
      'div id="footer"><a href="http://whitefyre.com/poxy/">PHProxy<' >< res ||
      'center"><a href="http://sourceforge.net/projects/poxy/">PHProxy</a>' >< res
    ) &&
    (
      '<input id="address_box" type="text" name="q"' >< res ||
      '<form name="poxy_url_form" method="' >< res ||
      '<form name="proxy_form" method="' >< res
    )
  )
  {
    security_note(port);
    exit(0);
  }
}

