#
# (C) Tenable Network Security, Inc.
#


if (description)
{
  script_id(29995);
  script_version("$Revision: 1.4 $");

  script_cve_id("CVE-2008-0358");
  script_bugtraq_id(27242);
  script_xref(name:"OSVDB", value:"40299");

  script_name(english:"Pixelpost parent_id Parameter SQL Injection Vulnerability");
  script_summary(english:"Tries to generate a SQL syntax error");

  desc = "
Synopsis :

The remote web server contains a PHP script that is prone to a SQL
injection attack. 

Description :

The remote host is running Pixelpost, a photo blog application based
on PHP and MySQL. 

The version of Pixelpost installed on the remote host fails to
sanitize input to the 'parent_id' parameter of the 'index.php' script
before using it to perform database queries.  Provided PHP's
'magic_quotes_gpc' setting is disabled, an attacker may be able to
exploit this issue to manipulate database queries to disclose
sensitive information, bypass authentication, modify data, or even
attack the underlying database. 

See also :

http://www.milw0rm.com/exploits/4924

Solution :

Unknown at this time.

Risk factor :

Medium / CVSS Base Score : 6.8
(CVSS2#AV:N/AC:M/Au:N/C:P/I:P/A:P)";
  script_description(english:desc);

  script_category(ACT_ATTACK);
  script_family(english:"CGI abuses");

  script_copyright(english:"This script is Copyright (C) 2008 Tenable Network Security, Inc.");

  script_dependencies("http_version.nasl");
  script_exclude_keys("Settings/disable_cgi_scanning");
  script_require_ports("Services/www", 80);

  exit(0);
}


include("global_settings.inc");
include("http_func.inc");
include("http_keepalive.inc");


port = get_http_port(default:80);
if (!get_port_state(port)) exit(0);
if (!can_host_php(port:port)) exit(0);


# Loop through directories.
if (thorough_tests) dirs = make_list("/pixelpost", cgi_dirs());
else dirs = make_list(cgi_dirs());

foreach dir (dirs)
{
  # Ensure we're looking at Pixelpost.
  url = string(dir, "/index.php");

  req = http_get(item:url, port:port);
  res = http_keepalive_send_recv(port:port, data:req, bodyonly:TRUE);
  if (res == NULL) exit(0);

  # If it is...
  if ('"Pixelpost' >< res)
  {
    # Try to exploit the issue to generate a syntax error.
    exploit = string(rand(), "'", SCRIPT_NAME);

    postdata = string(
      "parent_id='", exploit
    );
    req = string(
      "POST ", url, "?popup=comment HTTP/1.1\r\n",
      "Host: ", get_host_name(), "\r\n",
      "User-Agent: ", get_kb_item("global_settings/http_user_agent"), "\r\n",
      "Content-Type: application/x-www-form-urlencoded\r\n",
      "Content-Length: ", strlen(postdata), "\r\n",
      "\r\n",
      postdata
    );
    res = http_keepalive_send_recv(port:port, data:req, bodyonly:TRUE);
    if (res == NULL) exit(0);

    # There's a problem if we see an error message with our script name.
    if (string("right syntax to use near '", exploit, "'") >< res)
    {
      security_warning(port);
      exit(0);
    }
  }
}
