#
# (C) Tenable Network Security, Inc.
#


if (description)
{
  script_id(29746);
  script_version("$Revision: 1.3 $");

  script_cve_id("CVE-2007-6587");
  script_bugtraq_id(26958);
  script_xref(name:"OSVDB", value:"39764");

  script_name(english:"Plogger id Parameter SQL Injection Vulnerability");
  script_summary(english:"Tries to generate a SQL error");

  desc = "
Synopsis :

The remote web server contains a PHP script that is prone to a SQL
injection attack. 

Description :

The remote host appears to be running Plogger, an open-source photo
gallery written in PHP. 

The version of Plogger installed on the remote host fails to sanitize
input to the 'id' parameter of the 'plog-rss.php' script before using
it in a database query.  Regardless of PHP's 'magic_quotes_gpc' and
'register_globals' settings, an attacker may be able to exploit this
issue to manipulate database queries, leading to disclosure of
sensitive information, modification of data, or attacks against the
underlying database. 

See also :

http://www.nessus.org/u?69f2c406
http://dev.plogger.org/changeset/489

Solution :

Upgrade to Plogger 1.0 beta 3.0 if necessary and apply change set 489. 

Risk factor :

High / CVSS Base Score : 7.5
(CVSS2#AV:N/AC:L/Au:N/C:P/I:P/A:P)";
  script_description(english:desc);

  script_category(ACT_ATTACK);
  script_family(english:"CGI abuses");

  script_copyright(english:"This script is Copyright (C) 2007-2008 Tenable Network Security, Inc.");

  script_dependencies("http_version.nasl");
  script_exclude_keys("Settings/disable_cgi_scanning");
  script_require_ports("Services/www", 80);

  exit(0);
}


include("global_settings.inc");
include("http_func.inc");
include("http_keepalive.inc");
include("url_func.inc");


port = get_http_port(default:80);
if (!get_port_state(port)) exit(0);
if (!can_host_php(port:port)) exit(0);


# Loop through directories.
if (thorough_tests) dirs = make_list("/plogger", "/gallery", "/photos", cgi_dirs());
else dirs = make_list(cgi_dirs());

foreach dir (dirs)
{
  # Try to exploit the issue to generate a SQL error.
  exploit = string("999 OR ", SCRIPT_NAME);

  req = http_get(
    item:string(
      dir, "/plog-rss.php?",
      "level=collection&",
      "id=", urlencode(str:exploit)
    ), 
    port:port
  );
  res = http_keepalive_send_recv(port:port, data:req, bodyonly:TRUE);
  if (res == NULL) exit(0);

  # There's a problem if we see a SQL error involving our exploit
  if (string("WHERE p.`parent_collection` = ", exploit) >< res)
  {
    security_hole(port);
    exit(0);
  }
}
